/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import java.util.List;

public class RunnableInterceptor
implements Interceptor {
    private ThreadLocal<String> context = new ThreadLocal();
    private ThreadLocal<String> hasParent = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            Object lopsAttribute;
            if (object instanceof TransformAccess && (lopsAttribute = ((TransformAccess)object).getLopsAttribute()) != null && lopsAttribute instanceof List) {
                if (this.hasParent()) {
                    this.hasParent.set("true");
                    return null;
                }
                if (this.context.get() != null) {
                    return null;
                }
                this.context.set(className);
                ((TransformAccess)object).setLopsAttribute(null);
                List attrList = (List)lopsAttribute;
                String traceId = (String)attrList.get(0);
                String spanId = (String)attrList.get(1);
                String gtraceId = (String)attrList.get(2);
                List txName = (List)attrList.get(3);
                String userFlag = (String)attrList.get(4);
                if (traceId != null && spanId != null) {
                    StartTraceRequest traceRequest = new StartTraceRequest(className, methodName, traceId, spanId, gtraceId);
                    traceRequest.setKind("ASYNC_THREAD");
                    traceRequest.setSource(methodName + "()");
                    traceRequest.setRealSource(methodName + "()");
                    traceRequest.setDomainId(String.valueOf(IdentityConfigManager.getDomainId()));
                    TraceCollector.onStart((StartTraceRequest)traceRequest);
                } else if (gtraceId != null) {
                    TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(gtraceId);
                }
                if (userFlag != null) {
                    TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
                }
                if (txName != null) {
                    TransactionCollector.setTxName((List)txName);
                }
            }
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)exception);
        }
        return null;
    }

    private boolean hasParent() {
        SpanEvent parent = TraceCollector.getSpanEvent();
        return parent != null && !"java/lang/Thread".equals(parent.getClassName());
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            TraceCollector.onError((Throwable)e);
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (object instanceof TransformAccess) {
                if (this.hasParent.get() != null && "true".equals(this.hasParent.get())) {
                    this.hasParent.set(null);
                    return;
                }
                String contextValue = this.context.get();
                if (contextValue != null && contextValue.equals(className)) {
                    TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(null);
                    TraceCollector.USER_FLAG_THREAD_LOCAL.set(null);
                    TransactionCollector.clear();
                    this.context.set(null);
                    Thread t = Thread.currentThread();
                    String name = t.getName();
                    TraceCollector.addTag((String)"threadName", (String)name);
                    TraceCollector.onFinally((int)200);
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
    }
}

