/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.collector;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.collector.ProxyHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;

public class AsyncProxyCreate {
    private static boolean hasLog = false;

    public static Object getProxyObject(Object object, String traceId, String spanId, String gtraceId, List<String> txName, String userFlag) {
        try {
            String className = object.getClass().getName();
            if (object instanceof TransformAccess) {
                ((TransformAccess)object).setLopsAttribute(Arrays.asList(traceId, spanId, gtraceId, txName, userFlag));
            } else if (className.startsWith("sun.") || className.startsWith("java.") || className.startsWith("javax.") || className.contains("Lambda")) {
                ProxyHandler hanlder = new ProxyHandler(object, traceId, spanId, gtraceId, txName, userFlag);
                Class<?>[] interfaces = AsyncProxyCreate.getInterfaces(object.getClass());
                Object proxy = Proxy.newProxyInstance(object.getClass().getClassLoader(), interfaces, (InvocationHandler)hanlder);
                if (object instanceof Runnable) {
                    Runnable runableObj = (Runnable)proxy;
                    return runableObj;
                }
                return object;
            }
            return object;
        }
        catch (Exception e) {
            if (!hasLog) {
                LogFactory.getLogger().log(Level.SEVERE, "create runnable proxy  error", (Throwable)e);
                hasLog = true;
            }
            return object;
        }
    }

    private static Class<?>[] getInterfaces(Class classObj) {
        Class<?>[] interfaces = classObj.getInterfaces();
        Class superClass = classObj.getSuperclass();
        if (superClass != null) {
            Class<?>[] superInterfaces = AsyncProxyCreate.getInterfaces(superClass);
            Class[] newInterfaces = new Class[interfaces.length + superInterfaces.length];
            System.arraycopy(interfaces, 0, newInterfaces, 0, interfaces.length);
            System.arraycopy(superInterfaces, 0, newInterfaces, interfaces.length, superInterfaces.length);
            interfaces = newInterfaces;
        }
        return interfaces;
    }
}

