/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class CoapStats
extends UrlStats {
    private static final String REQUEST_TYPE = "requestType";
    private static final String ENV_ID = "envId";
    private static final String LAST_ERROR = "lastError";
    private static final String SLOW_TRACE_ID = "slowTraceId";
    private static final String ERROR_TRACE_ID = "errorTraceId";
    private final AtomicLong completeCount = new AtomicLong(0L);
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private String envId;
    private boolean isConType;

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    public boolean onFinally(long timeUsed) {
        this.completeCount.incrementAndGet();
        return super.onFinally(timeUsed);
    }

    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)LAST_ERROR, (Object)this.lastError.get());
        row.put((Object)SLOW_TRACE_ID, (Object)this.slowTraceId.get());
        row.put((Object)ERROR_TRACE_ID, (Object)this.errorTraceId.get());
        if (this.envId != null) {
            row.put((Object)ENV_ID, (Object)this.envId);
        }
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.put((Object)LAST_ERROR, this.lastError.getAndSet(null));
        row.put((Object)SLOW_TRACE_ID, this.slowTraceId.getAndSet(null));
        row.put((Object)ERROR_TRACE_ID, this.errorTraceId.getAndSet(null));
        row.put((Object)REQUEST_TYPE, (Object)(this.isConType ? "CON" : "NON"));
        if (this.envId != null) {
            row.put((Object)ENV_ID, (Object)this.envId);
        }
        return row;
    }

    public String getEnvId() {
        return this.envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }

    public boolean isConType() {
        return this.isConType;
    }

    public void setConType(boolean isConType) {
        this.isConType = isConType;
    }
}

