/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.server.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.coapcalifornium.CoapUtils;
import com.lubanops.apm.plugin.coapcalifornium.server.collector.CoapServerCollector;
import com.lubanops.apm.plugin.coapcalifornium.server.stats.CoapClusterStats;
import com.lubanops.apm.plugin.coapcalifornium.stats.CoapStats;
import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;

public class ExchangeSendResponseInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (CoapServerCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Response) {
                Response response = (Response)args[0];
                OptionSet optionSet = response.getOptions();
                List arbitraryOptions = optionSet.getOthers();
                String envId = String.valueOf(IdentityConfigManager.getEnvId());
                boolean hasEnvId = false;
                for (Option option : arbitraryOptions) {
                    int num = option.getNumber();
                    if (num != 1001) continue;
                    hasEnvId = true;
                    option.setStringValue(envId);
                    break;
                }
                if (!hasEnvId) {
                    optionSet.addOption(new Option(1001, envId));
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (CoapServerCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Response) {
                String traceId;
                Response response = (Response)args[0];
                Request request = ((Exchange)object).getRequest();
                CoAP.ResponseCode code = response.getCode();
                boolean isSuccess = CoAP.ResponseCode.isSuccess((CoAP.ResponseCode)code);
                String statusInfo = code.toString();
                SpanEvent spanEvent = (SpanEvent)CoapUtils.getFromLopsAttribute(object, "spanEvent");
                Map collectorContext = (Map)CoapUtils.getFromLopsAttribute(object, "serverCollectorContext");
                CoapStats stats = (CoapStats)((Object)collectorContext.get("statsBase"));
                CoapClusterStats coapClusterStats = (CoapClusterStats)((Object)collectorContext.get("clusterStats"));
                Long startTime = (Long)collectorContext.get("startTime");
                String string = traceId = spanEvent == null ? null : spanEvent.getTraceId();
                if (!isSuccess) {
                    CoapServerCollector.onError(stats, coapClusterStats, code, traceId);
                    if (spanEvent != null) {
                        spanEvent.setSpanError(true);
                        spanEvent.setErrorReasons(statusInfo);
                    }
                }
                int statusCode = CoapUtils.getCoapCodeInInt(code.toString());
                if (spanEvent != null) {
                    spanEvent.addTag("coap.response.code", statusInfo);
                    spanEvent.setCode(statusCode);
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
                CoapServerCollector.onStatusInfo(request.getURI(), statusInfo);
                CoapServerCollector.onFinally(stats, coapClusterStats, startTime, traceId);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

