/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.client.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.coapcalifornium.CoapUtils;
import com.lubanops.apm.plugin.coapcalifornium.client.collector.CoapClientCollector;
import com.lubanops.apm.plugin.coapcalifornium.stats.CoapStats;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Endpoint;

public class CoapClientSendInterceptor
implements Interceptor {
    public CoapClientSendInterceptor() {
        CoapClientCollector.setVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)CoapClient.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (CoapClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Request && args[1] != null && args[1] instanceof Endpoint) {
                Request request = (Request)args[0];
                Map<String, Object> collectorContext = this.processRequest(request, className, methodName);
                CoapUtils.saveToLopsAttribute(request, "clientCollectorContext", collectorContext);
                CoapUtils.saveSpanEvent(request);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return new Object[0];
    }

    private Map<String, Object> processRequest(Request request, String className, String methodName) {
        String gTraceId;
        String requestUri = request.getURI();
        String requestType = request.getType().name();
        String methodType = request.getCode().name();
        String mid = String.valueOf(request.getMID());
        boolean isObserve = request.isObserve();
        boolean isMulticast = request.isMulticast();
        OptionSet optionSet = request.getOptions();
        List arbitraryOptions = optionSet.getOthers();
        Map<String, Integer> indexes = this.getIndexes(arbitraryOptions);
        String envId = String.valueOf(IdentityConfigManager.getEnvId());
        String domainId = String.valueOf(IdentityConfigManager.getDomainId());
        int envIdIndex = indexes.get("envId");
        int domainIdIndex = indexes.get("domainId");
        if (envIdIndex == -1) {
            optionSet.addOption(new Option(1001, envId));
        } else {
            ((Option)arbitraryOptions.get(envIdIndex)).setStringValue(envId);
        }
        if (domainIdIndex == -1) {
            optionSet.addOption(new Option(1002, domainId));
        } else {
            ((Option)arbitraryOptions.get(domainIdIndex)).setStringValue(domainId);
        }
        SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"CoapClient");
        if (spanEvent != null) {
            spanEvent.addTag("coap.msg.url", requestUri);
            spanEvent.addTag("coap.msg.type", requestType);
            spanEvent.addTag("coap.msg.method", methodType);
            spanEvent.addTag("coap.msg.direction", "outgoing");
            spanEvent.addTag("coap.msg.isObserve", String.valueOf(isObserve));
            spanEvent.addTag("coap.msg.isMulticast", String.valueOf(isMulticast));
            spanEvent.addTag("coap.mid", mid);
            this.processSpanEventIds(spanEvent, indexes, optionSet, arbitraryOptions);
        }
        if (!StringUtils.isBlank((String)(gTraceId = TraceCollector.getVirtualTraceId()))) {
            optionSet.addOption(new Option(1006, gTraceId));
        }
        return CoapClientCollector.onStart(requestUri, requestType, methodType);
    }

    private void processSpanEventIds(SpanEvent spanEvent, Map<String, Integer> indexes, OptionSet optionSet, List<Option> arbitraryOptions) {
        if (spanEvent != null) {
            String nextSpanId = spanEvent.generateNextSpanId();
            String traceId = spanEvent.getTraceId();
            int traceIdIndex = indexes.get("traceId");
            int spanIdIndex = indexes.get("spanId");
            int sourceEventId = indexes.get("sourceEventId");
            if (traceIdIndex == -1) {
                optionSet.addOption(new Option(1003, traceId));
            } else {
                arbitraryOptions.get(traceIdIndex).setStringValue(traceId);
            }
            if (spanIdIndex == -1) {
                optionSet.addOption(new Option(1004, nextSpanId));
            } else {
                arbitraryOptions.get(spanIdIndex).setStringValue(nextSpanId);
            }
            if (sourceEventId == -1) {
                optionSet.addOption(new Option(1005, spanEvent.getEventId()));
            } else {
                arbitraryOptions.get(sourceEventId).setStringValue(spanEvent.getEventId());
            }
        }
    }

    private Map<String, Integer> getIndexes(List<Option> arbitraryOptions) {
        int envIdIndex = -1;
        int domainIdIndex = -1;
        int traceIdIndex = -1;
        int spanIdIndex = -1;
        int sourceEventId = -1;
        for (int i = 0; i < arbitraryOptions.size(); ++i) {
            int num = arbitraryOptions.get(i).getNumber();
            if (num == 1001) {
                envIdIndex = i;
                continue;
            }
            if (num == 1002) {
                domainIdIndex = i;
                continue;
            }
            if (num == 1003) {
                traceIdIndex = i;
                continue;
            }
            if (num == 1004) {
                spanIdIndex = i;
                continue;
            }
            if (num != 1005) continue;
            sourceEventId = i;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("envId", envIdIndex);
        map.put("domainId", domainIdIndex);
        map.put("traceId", traceIdIndex);
        map.put("spanId", spanIdIndex);
        map.put("sourceEventId", sourceEventId);
        return map;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (CoapClientCollector.INSTANCE.isEnable() && args[0] != null && args[0] instanceof Request && args[1] != null && args[1] instanceof Endpoint) {
                Request request = (Request)args[0];
                if (request.getType() == CoAP.Type.CON) {
                    TraceCollector.onFinally((boolean)false);
                    return;
                }
                Map clientContext = (Map)CoapUtils.getFromLopsAttribute(request, "clientCollectorContext");
                CoapStats stats = (CoapStats)((Object)clientContext.get("statsBase"));
                Long startTime = (Long)clientContext.get("startTime");
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)true);
                CoapClientCollector.nonRequestSent(stats, startTime);
                CoapClientCollector.onStatusInfo(true, "NonTypeRequestSent", request.getURI(), stats, spanEvent == null ? null : spanEvent.getTraceId());
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

