/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.hbase.HBaseUtils;
import com.lubanops.apm.plugin.hbase.collector.HBaseCollector;
import java.util.Queue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;

public class ScannerLoadCacheInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable() && object instanceof AttributeAccess) {
                AttributeAccess attributeAccess = (AttributeAccess)object;
                Scan scan = (Scan)attributeAccess.getLopsFileds()[0];
                Queue queue = (Queue)attributeAccess.getLopsFileds()[1];
                TableName tableName = (TableName)attributeAccess.getLopsFileds()[2];
                String tableNameWithNamespace = HBaseUtils.getTableNameWithNamespace(tableName);
                String parsedScan = HBaseUtils.parseScan(scan);
                if (object instanceof TransformAccess) {
                    TransformAccess transformAccess = (TransformAccess)object;
                    transformAccess.setLopsAttribute((Object)queue.size());
                }
                HBaseCollector.onStart(tableNameWithNamespace, parsedScan);
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"HBase");
                if (spanEvent != null) {
                    spanEvent.addTag("Table Name", tableNameWithNamespace);
                    spanEvent.addTag("Command", parsedScan);
                }
            }
        }
        catch (Exception loadCacheException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)loadCacheException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                HBaseCollector.onRequestError(TraceCollector.getTraceId());
                HBaseCollector.onException(e);
            }
        }
        catch (Exception loadCacheException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)loadCacheException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable() && object instanceof AttributeAccess) {
                AttributeAccess attributeAccess = (AttributeAccess)object;
                if (object instanceof TransformAccess) {
                    TransformAccess transformAccess = (TransformAccess)object;
                    Queue queue = (Queue)attributeAccess.getLopsFileds()[1];
                    int loadNum = queue.size() - (Integer)transformAccess.getLopsAttribute();
                    HBaseCollector.incrementQueryRowCount(loadNum);
                    SpanEvent spanEvent = TraceCollector.getSpanEvent();
                    if (spanEvent != null) {
                        spanEvent.addTag("Rows Queried", String.valueOf(loadNum));
                    }
                }
                HBaseCollector.onFinally();
                TraceCollector.onFinally();
            }
        }
        catch (Exception loadCacheException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)loadCacheException);
        }
    }
}

