/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.hbase.HBaseUtils;
import com.lubanops.apm.plugin.hbase.collector.HBaseCollector;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.util.Bytes;

public class DoCheckAndMutateInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                HTable table = (HTable)object;
                String tableNameWithNamespace = HBaseUtils.getTableNameWithNamespace(table);
                String family = Bytes.toString((byte[])((byte[])args[1]));
                String qualifier = Bytes.toString((byte[])((byte[])args[2]));
                CompareOperator op = (CompareOperator)args[3];
                Filter filter = (Filter)args[5];
                String parsed = args[7] instanceof Mutation ? HBaseUtils.parseCheckAndMutate(family, qualifier, op, filter, (Mutation)args[7]) : HBaseUtils.parseCheckAndMutations(family, qualifier, op, filter, (RowMutations)args[7]);
                HBaseCollector.onStart(tableNameWithNamespace, parsed);
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"HBase");
                if (spanEvent != null) {
                    spanEvent.addTag("Table Name", tableNameWithNamespace);
                    spanEvent.addTag("Command", parsed);
                }
            }
        }
        catch (Exception doCheckAndMutateException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)doCheckAndMutateException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                HBaseCollector.onRequestError(TraceCollector.getTraceId());
                HBaseCollector.onException(e);
            }
        }
        catch (Exception doCheckAndMutateException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)doCheckAndMutateException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!HBaseCollector.INSTANCE.isEnable()) break block7;
                boolean isMutated = false;
                try {
                    Class<?> resultClass = Class.forName("org.apache.hadoop.hbase.client.CheckAndMutateResult");
                    if (resultClass.isInstance(result)) {
                        isMutated = ((CheckAndMutateResult)result).isSuccess();
                    }
                }
                catch (ClassNotFoundException notFoundException) {
                    isMutated = (Boolean)result;
                }
                if (isMutated) {
                    HBaseCollector.incrementUpdateRowCount(1L);
                    SpanEvent spanEvent = TraceCollector.getSpanEvent();
                    if (spanEvent != null) {
                        spanEvent.addTag("Rows Updated", "1");
                    }
                }
                HBaseCollector.onFinally();
                TraceCollector.onFinally();
            }
            catch (Exception doCheckAndMutateException) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)doCheckAndMutateException);
            }
        }
    }
}

