/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.hbase.stats.HBaseClientStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HBaseClientAggregator
extends MultiPrimaryKeyAggregator<HBaseClientStats> {
    private static final String TABLE_WITH_NAMESPACE = "namespaceTable";
    private static final String COMMAND = "command";
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<HBaseClientStats> statsLocal = new ThreadLocal();
    private final ThreadLocal<Long> loadMetaStartTimeLocal = new ThreadLocal();
    private final ThreadLocal<HBaseClientStats> loadMetaStatsLocal = new ThreadLocal();
    private final ThreadLocal<Boolean> errorLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
    }

    public void incrementQueryRowCount(long count) {
        if (!this.isEnable) {
            return;
        }
        HBaseClientStats stats = this.getCurrentStats();
        Long startTime = this.getCurrentStartTime();
        if (stats != null && startTime != null) {
            stats.incrementQueryRowCount(count);
        }
    }

    public void incrementUpdateRowCount(long count) {
        if (!this.isEnable) {
            return;
        }
        HBaseClientStats stats = this.getCurrentStats();
        Long startTime = this.getCurrentStartTime();
        if (stats != null && startTime != null) {
            stats.incrementUpdateRowCount(count);
        }
    }

    public void onStart(String tableWithNamespace, String command) {
        if (!this.isEnable) {
            return;
        }
        HBaseClientStats stats = (HBaseClientStats)this.getValue(new String[]{tableWithNamespace, command});
        long startTime = stats.onStart();
        if (this.statsLocal.get() != null && this.startTimeLocal.get() != null) {
            this.loadMetaStatsLocal.set(stats);
            this.loadMetaStartTimeLocal.set(startTime);
        } else {
            this.statsLocal.set(stats);
            this.startTimeLocal.set(startTime);
        }
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        HBaseClientStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
        }
    }

    public void onFinally() {
        if (!this.isEnable) {
            return;
        }
        HBaseClientStats stats = this.getCurrentStatsAndSetNull();
        Long startTime = this.getCurrentStartTimeAndSetNull();
        if (stats != null && startTime != null && stats.onFinally(System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
    }

    private HBaseClientStats getCurrentStats() {
        HBaseClientStats loadMetaStats = this.loadMetaStatsLocal.get();
        HBaseClientStats stats = loadMetaStats == null ? this.statsLocal.get() : loadMetaStats;
        return stats;
    }

    private Long getCurrentStartTime() {
        Long loadMetaStartTime = this.loadMetaStartTimeLocal.get();
        Long startTime = loadMetaStartTime == null ? this.startTimeLocal.get() : loadMetaStartTime;
        return startTime;
    }

    private HBaseClientStats getCurrentStatsAndSetNull() {
        HBaseClientStats stats;
        HBaseClientStats loadMetaStats = this.loadMetaStatsLocal.get();
        if (loadMetaStats == null) {
            stats = this.statsLocal.get();
            this.statsLocal.remove();
        } else {
            stats = loadMetaStats;
            this.loadMetaStatsLocal.remove();
        }
        return stats;
    }

    private Long getCurrentStartTimeAndSetNull() {
        Long startTime;
        Long loadMetaStartTime = this.loadMetaStartTimeLocal.get();
        if (loadMetaStartTime == null) {
            startTime = this.startTimeLocal.get();
            this.startTimeLocal.remove();
        } else {
            startTime = loadMetaStartTime;
            this.loadMetaStartTimeLocal.remove();
        }
        return startTime;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalInvokeCount = 0L;
        long totalQueryCount = 0L;
        long totalUpdateCount = 0L;
        long totalErrorCount = 0L;
        long totalTotalTime = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long invokeCount = (Long)row.get((Object)"invokeCount");
                Long queryCount = (Long)row.get((Object)"queryRowCount");
                Long updateCount = (Long)row.get((Object)"updateRowCount");
                Long errorCount = (Long)row.get((Object)"errorCount");
                Long totalTime = (Long)row.get((Object)"totalTime");
                if (invokeCount == null) {
                    invokeCount = 0L;
                }
                if (queryCount == null) {
                    queryCount = 0L;
                }
                if (updateCount == null) {
                    updateCount = 0L;
                }
                if (errorCount == null) {
                    errorCount = 0L;
                }
                if (totalTime == null) {
                    totalTime = 0L;
                }
                totalInvokeCount += invokeCount.longValue();
                totalQueryCount += queryCount.longValue();
                totalUpdateCount += updateCount.longValue();
                totalErrorCount += errorCount.longValue();
                totalTotalTime += totalTime.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"invokeCount", (Object)totalInvokeCount);
        totalRow.put((Object)"queryRowCount", (Object)totalQueryCount);
        totalRow.put((Object)"updateRowCount", (Object)totalUpdateCount);
        totalRow.put((Object)"errorCount", (Object)totalErrorCount);
        totalRow.put((Object)"totalTime", (Object)totalTotalTime);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    protected Class<HBaseClientStats> getValueType() {
        return HBaseClientStats.class;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(TABLE_WITH_NAMESPACE, COMMAND);
    }

    public String getName() {
        return "client";
    }
}

