/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.premain;

import com.lubanops.apm.bootstrap.log.CollectorLogFactory;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.LogPathUtils;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.premain.agent.AgentStatus;
import com.lubanops.apm.premain.agent.ArgumentBuilder;
import com.lubanops.apm.premain.classloader.LopsUrlClassLoader;
import com.lubanops.apm.premain.utils.LibPathUtils;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public class AgentPremain {
    private static final String AGENT_JAR_FILE_NAME = "apm-javaagent.jar";
    private static AgentStatus agentStatus = AgentStatus.STOPPED;
    private static ArgumentBuilder argumentBuilder = new ArgumentBuilder();

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        try {
            if (AgentStatus.STOPPED.equals((Object)agentStatus)) {
                agentStatus = AgentStatus.LOADING;
                AgentPremain.loadBootstrap(instrumentation);
                Map argsMap = argumentBuilder.build(agentArgs, new LogInitCallback());
                final List<URL> urls = LibPathUtils.getLibUrl();
                urls.add(AgentPremain.class.getProtectionDomain().getCodeSource().getLocation());
                LogFactory.getLogger().info("[APM PREMAIN]loading javaagent.");
                AgentPremain.addAgentPath(argsMap);
                ClassLoader parent = Thread.currentThread().getContextClassLoader();
                LopsUrlClassLoader classLoader = (LopsUrlClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new LopsUrlClassLoader(urls.toArray(new URL[urls.size()]), AgentPremain.class.getClassLoader());
                    }
                });
                Thread.currentThread().setContextClassLoader(classLoader);
                Class<?> mainClass = classLoader.loadClass("com.lubanops.apm.core.BootStrapImpl");
                Method startMethod = mainClass.getDeclaredMethod("main", Instrumentation.class, Map.class);
                startMethod.invoke(null, instrumentation, argsMap);
                Thread.currentThread().setContextClassLoader(parent);
            } else {
                LogFactory.getLogger().log(Level.SEVERE, "[APM PREMAIN]The JavaAgent is loaded repeatedly.");
            }
            agentStatus = AgentStatus.STARTED;
        }
        catch (InvocationTargetException e) {
            LogFactory.getLogger().log(Level.SEVERE, "[APM PREMAIN]Loading javaagent failed", e.getTargetException());
        }
        catch (Exception e) {
            e.printStackTrace();
            LogFactory.getLogger().log(Level.SEVERE, "[APM PREMAIN]Loading javaagent failed", (Throwable)e);
        }
    }

    private static void addAgentPath(Map argsMap) {
        String agentPath = LibPathUtils.getAgentPath();
        String bootPath = LibPathUtils.getBootstrapJarPath();
        String pluginsPath = LibPathUtils.getPluginsJarPath();
        argsMap.put("agentPath", agentPath);
        argsMap.put("bootPath", bootPath);
        argsMap.put("pluginsPath", pluginsPath);
    }

    private static void loadBootstrap(Instrumentation instrumentation) throws IOException {
        ProtectionDomain pd = AgentPremain.class.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        String jarPath = cs.getLocation().getPath();
        String agentPath = jarPath.substring(0, jarPath.lastIndexOf(AGENT_JAR_FILE_NAME));
        String bootPath = agentPath + File.separator + "boot";
        ArrayList<JarFile> bootstrapJar = new ArrayList<JarFile>();
        File libDir = new File(bootPath);
        File[] files = libDir.listFiles();
        if (files != null) {
            for (File file : files) {
                bootstrapJar.add(new JarFile(file));
            }
        }
        for (JarFile jar : bootstrapJar) {
            instrumentation.appendToBootstrapClassLoaderSearch(jar);
        }
    }

    public static class LogInitCallback {
        public void initLog(String appName, String instanceName, String path) {
            LogPathUtils.build((String)appName, (String)instanceName, (String)path);
            Logger apmLogger = CollectorLogFactory.getLogger();
            LogFactory.setLogger((Logger)apmLogger);
        }
    }
}

