/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.schema.FormatValidator;
import com.alibaba.fastjson2.util.UUIDUtils;

final class UUIDValidator
implements FormatValidator {
    static final UUIDValidator INSTANCE = new UUIDValidator();

    UUIDValidator() {
    }

    @Override
    public boolean isValid(String str) {
        if (str == null) {
            return false;
        }
        if (str.length() == 32) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1 = UUIDUtils.parse4Nibbles(str, 0);
            return (msb1 | (msb2 = UUIDUtils.parse4Nibbles(str, 4)) | (msb3 = UUIDUtils.parse4Nibbles(str, 8)) | (msb4 = UUIDUtils.parse4Nibbles(str, 12)) | (lsb1 = UUIDUtils.parse4Nibbles(str, 16)) | (lsb2 = UUIDUtils.parse4Nibbles(str, 20)) | (lsb3 = UUIDUtils.parse4Nibbles(str, 24)) | (lsb4 = UUIDUtils.parse4Nibbles(str, 28))) >= 0L;
        }
        if (str.length() == 36) {
            char ch1 = str.charAt(8);
            char ch2 = str.charAt(13);
            char ch3 = str.charAt(18);
            char ch4 = str.charAt(23);
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-') {
                long lsb4;
                long lsb3;
                long lsb2;
                long lsb1;
                long msb4;
                long msb3;
                long msb2;
                long msb1 = UUIDUtils.parse4Nibbles(str, 0);
                return (msb1 | (msb2 = UUIDUtils.parse4Nibbles(str, 4)) | (msb3 = UUIDUtils.parse4Nibbles(str, 9)) | (msb4 = UUIDUtils.parse4Nibbles(str, 14)) | (lsb1 = UUIDUtils.parse4Nibbles(str, 19)) | (lsb2 = UUIDUtils.parse4Nibbles(str, 24)) | (lsb3 = UUIDUtils.parse4Nibbles(str, 28)) | (lsb4 = UUIDUtils.parse4Nibbles(str, 32))) >= 0L;
            }
        }
        return false;
    }
}

