/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.gaussdb.zenith.interceptor;

import com.huawei.gauss.jdbc.inner.GaussConnectionImpl;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.gaussdb.zenith.GaussUtils;
import com.lubanops.apm.plugin.gaussdb.zenith.collector.GaussDbCollector;
import java.net.SocketAddress;
import java.security.ProtectionDomain;

public class ConnectionConnectInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public ConnectionConnectInterceptor() {
        GaussDbCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)GaussConnectionImpl.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            this.hasErrorLocal.set(Boolean.TRUE);
            GaussDbCollector.onThrowable(e);
        }
        catch (Exception connectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)connectionException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            boolean hasError = Boolean.TRUE.equals(this.hasErrorLocal.get());
            if (!hasError) {
                String address = "unknown";
                if (args.length >= 1 && args[0] instanceof SocketAddress) {
                    address = GaussUtils.getHostPostPair((SocketAddress)args[0]);
                } else if (args.length >= 2 && args[0] instanceof String && args[1] instanceof String) {
                    address = args[0] + ":" + args[1];
                }
                GaussConnectionImpl connection = (GaussConnectionImpl)object;
                String catalog = connection.getCatalog();
                if (catalog == null) {
                    catalog = "unset";
                }
                String dbName = Helper.getDbName((String)address, (String)catalog);
                Integer id = Helper.CONNECTION_TARGET_MAP.registerResource(dbName);
                if (object instanceof TransformAccess) {
                    ((TransformAccess)object).setLopsAttribute((Object)id);
                }
                GaussDbCollector.onConnectionCreated(id);
            }
            this.hasErrorLocal.remove();
        }
        catch (Exception connectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)connectionException);
        }
    }
}

