/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.obsclient.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import java.util.concurrent.atomic.AtomicReference;

public class ObsClientStats
extends DefaultSectionStats {
    private final AtomicReference<String> lastError = new AtomicReference();

    public void onThrowable(Throwable t) {
        super.onThrowable(t);
        if (this.lastError.get() == null) {
            String stackTrace = ExceptionUtil.getThrowableStackTrace((Throwable)t, (boolean)false);
            this.lastError.set(stackTrace);
        }
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"lastError", (Object)this.lastError.get());
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.put((Object)"lastError", this.lastError.getAndSet(null));
        return row;
    }
}

