/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.obsclient.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultStatusCodeAggregator;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlOverallAggregator;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.obsclient.collector.ObsClientInvocationAggregator;
import java.util.List;
import java.util.Map;

public class ObsClientCollector
extends Collector {
    public static final ObsClientCollector INSTANCE = new ObsClientCollector();
    private static final ObsClientInvocationAggregator OBS_CLIENT_INVOCATION_AGGREGATOR = new ObsClientInvocationAggregator();
    private static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    private static final DefaultStatusCodeAggregator STATUS_CODE_AGGREGATOR = new DefaultStatusCodeAggregator();
    private static final UrlOverallAggregator URL_OVERALL_AGGREGATOR = new UrlOverallAggregator();
    private static final String KEY_FORMAT = "{key}";
    private static final int EXPECTED_ERROR_CODE = 400;

    public static void onStart(String hostUri, String requestUri, String method, String bucketName, List<String> objectKey) {
        String targetUrl = ObsClientCollector.getTargetUrl(requestUri);
        if (null != bucketName && !"".equals(bucketName.trim())) {
            hostUri = hostUri.replace(bucketName + ".", "");
        }
        for (String key : objectKey) {
            if (null == key || "".equals(key.trim())) continue;
            targetUrl = targetUrl.replace(key, KEY_FORMAT);
        }
        OBS_CLIENT_INVOCATION_AGGREGATOR.onStart(hostUri, targetUrl, method);
    }

    private static String getTargetUrl(String requestUri) {
        int i = requestUri.indexOf(63);
        return i <= 0 ? requestUri : requestUri.substring(0, i);
    }

    public static void onStatusCode(String url, int code) {
        STATUS_CODE_AGGREGATOR.onStatusCode(url, code);
        if (code >= 400) {
            OBS_CLIENT_INVOCATION_AGGREGATOR.onError();
        }
    }

    public static void onThrowable(Throwable t) {
        boolean flag = OBS_CLIENT_INVOCATION_AGGREGATOR.onThrowable(t);
        if (flag) {
            EXCEPTION_AGGREGATOR.onThrowable(t);
        }
    }

    public static void onFinally(int code) {
        boolean urlHasError = code >= 400;
        long timeUsed = OBS_CLIENT_INVOCATION_AGGREGATOR.onFinally();
        if (timeUsed > 0L && URL_OVERALL_AGGREGATOR.isEnable()) {
            URL_OVERALL_AGGREGATOR.onTotal(timeUsed);
            if (urlHasError) {
                URL_OVERALL_AGGREGATOR.onError();
            }
        }
        TransactionCollector.collect((long)timeUsed, (boolean)urlHasError, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)OBS_CLIENT_INVOCATION_AGGREGATOR.getHost(), (List)TransactionCollector.getTxName(), (String)"ObsClient");
        OBS_CLIENT_INVOCATION_AGGREGATOR.clearThreadLocal();
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "ObsClient";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)OBS_CLIENT_INVOCATION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)STATUS_CODE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)URL_OVERALL_AGGREGATOR);
        INSTANCE.register();
    }
}

