/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cassandra3.interceptor;

import com.datastax.driver.core.Host;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.cassandra3.CassandraUtils;
import com.lubanops.apm.plugin.cassandra3.apreload.CassandraStats;
import com.lubanops.apm.plugin.cassandra3.collector.CassandraCollector;
import java.util.Map;
import java.util.concurrent.Executor;

public class BorrowConnectionInterceptor
implements Interceptor {
    public final ThreadLocal<Map<String, Object>> connectionContextLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (CassandraCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"Cassandra");
                Host host = (Host)((AttributeAccess)object).getLopsFileds()[0];
                String hostAsString = CassandraUtils.withPrefixSlashRemoved(host.toString());
                if (spanEvent != null) {
                    spanEvent.addTag("host", hostAsString);
                }
                Map<String, Object> map = CassandraCollector.onConnectionStartAsync(hostAsString);
                this.connectionContextLocal.set(map);
            }
        }
        catch (Exception borrowConnectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)borrowConnectionException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (CassandraCollector.INSTANCE.isEnable()) {
                ListenableFuture listenableFuture = (ListenableFuture)result;
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                Map<String, Object> context = this.connectionContextLocal.get();
                this.connectionContextLocal.remove();
                this.addExecutionCallback(listenableFuture, spanEvent, context);
                TraceCollector.onFinally((boolean)false);
            }
        }
        catch (Exception borrowConnectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)borrowConnectionException);
        }
    }

    private void addExecutionCallback(ListenableFuture future, final SpanEvent spanEvent, final Map<String, Object> context) {
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                BorrowConnectionInterceptor.this.executeOnSuccess(result, spanEvent, context);
            }

            public void onFailure(Throwable t) {
                BorrowConnectionInterceptor.this.executeOnFailure(t, spanEvent, context);
            }
        }, (Executor)new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    private void executeOnSuccess(Object result, SpanEvent spanEvent, Map<String, Object> context) {
        long timeUsed;
        Long startTime = (Long)context.get("startTime");
        CassandraStats stats = (CassandraStats)((Object)context.get("stats"));
        String traceId = spanEvent == null ? null : spanEvent.getTraceId();
        CassandraCollector.onConnectionFinallyAsync(startTime, stats, traceId);
        if (spanEvent != null && (timeUsed = System.nanoTime() - spanEvent.getStartNanoTime()) >= (long)CassandraCollector.getTimeSpanThreshold()) {
            spanEvent.setTimeUsed(timeUsed);
            TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
        }
    }

    private void executeOnFailure(Throwable t, SpanEvent spanEvent, Map<String, Object> context) {
        Long startTime = (Long)context.get("startTime");
        CassandraStats stats = (CassandraStats)((Object)context.get("stats"));
        String traceId = spanEvent == null ? null : spanEvent.getTraceId();
        CassandraCollector.onException(t);
        CassandraCollector.onConnectionErrorAsync(stats, traceId);
        CassandraCollector.onConnectionFinallyAsync(startTime, stats, traceId);
        if (spanEvent != null) {
            TraceCollector.onError((SpanEvent)spanEvent, (Throwable)t);
            TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
        }
    }
}

