/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.spring.collector;

import com.lubanops.apm.bootstrap.api.InstrumentationManager;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.plugin.spring.collector.SpringBeanAggregator;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SpringBeanMethodCollector
extends Collector {
    private static final Logger LOGGER = LogFactory.getLogger();
    public static final SpringBeanMethodCollector INSTANCE = new SpringBeanMethodCollector();
    public static final SpringBeanAggregator SPRING_BEAN_AGGREGATOR = new SpringBeanAggregator();
    private static Map<String, Boolean> needCountMap = new ConcurrentHashMap<String, Boolean>();
    private List<SpringBeanMethodPattern> methodPatterns = new ArrayList<SpringBeanMethodPattern>();
    private HashMap<String, SpringBeanMethodPattern> methodPatternMap = new HashMap();

    public static SpringBeanMethodCollector getInstance() {
        return INSTANCE;
    }

    public static void setNeedCount(String className, Boolean needCount) {
        needCountMap.put(className, needCount);
    }

    public static boolean needCount(String className) {
        Boolean result = needCountMap.get(className);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public void retransForm(SpringBeanMethodPattern newMethodPattern, Class beanClass) {
        this.methodPatterns.add(newMethodPattern);
        if (InstrumentationManager.inst != null) {
            this.retransformClasses(beanClass);
        }
    }

    public String getCollectorName() {
        return "SpringBean";
    }

    private void retransformClasses(Class beanClass) {
        try {
            String className = beanClass.getName();
            if (className.startsWith("com.lubanops.apm")) {
                return;
            }
            if ((className.startsWith("com") || className.startsWith("org")) && !className.contains("$") && !SpringBeanMethodCollector.needCount(className)) {
                InstrumentationManager.inst.retransformClasses(beanClass);
                SpringBeanMethodCollector.setNeedCount(className, true);
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "javamethod retranform failed", e);
        }
    }

    public List<SpringBeanMethodPattern> getMethodPatterns() {
        return this.methodPatterns;
    }

    public void setMethodPatterns(List<SpringBeanMethodPattern> methodPatterns) {
        this.methodPatterns = methodPatterns;
    }

    public HashMap<String, SpringBeanMethodPattern> getMethodPatternMap() {
        return this.methodPatternMap;
    }

    public void setMethodPatternMap(HashMap<String, SpringBeanMethodPattern> methodPatternMap) {
        this.methodPatternMap = methodPatternMap;
    }

    public void putMethodPattern(String className, SpringBeanMethodPattern methodPattern) {
        int springBeanMaxNumber = AgentConfigManager.getSpringBeanMaxNumber();
        if (this.methodPatternMap.size() > springBeanMaxNumber) {
            LOGGER.info("method pattern map length excced " + springBeanMaxNumber);
            return;
        }
        this.methodPatternMap.put(className, methodPattern);
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)SPRING_BEAN_AGGREGATOR);
        INSTANCE.register();
    }
}

