/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.grpc.server.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.grpc.GRPCContext;
import com.lubanops.apm.plugin.grpc.server.collector.GRPCSampleFilter;
import com.lubanops.apm.plugin.grpc.server.collector.SeverCollector;
import io.grpc.Metadata;
import java.util.HashMap;
import java.util.Map;

public class ServerImplInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (SeverCollector.INSTANCE.isEnable()) {
                String grpcMethodName = (String)args[1];
                Metadata metadata = (Metadata)args[2];
                String domainId = (String)metadata.get(Metadata.Key.of((String)Headers.DOMAIN_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String domainType = (String)metadata.get(Metadata.Key.of((String)Headers.DOMAIN_TYPE.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String traceId = (String)metadata.get(Metadata.Key.of((String)Headers.TRACE_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String spanId = (String)metadata.get(Metadata.Key.of((String)Headers.SPAN_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String sourceEventId = (String)metadata.get(Metadata.Key.of((String)Headers.SOURCE_EVENT_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String envId = (String)metadata.get(Metadata.Key.of((String)Headers.ENV_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String gtraceId = (String)metadata.get(Metadata.Key.of((String)Headers.GTRACE_ID.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String userFlag = (String)metadata.get(Metadata.Key.of((String)Headers.USER_FLAG.getValue(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, traceId, spanId, gtraceId);
                startTraceRequest.setKind("GRPCServer");
                startTraceRequest.setSource(grpcMethodName);
                startTraceRequest.setRealSource(grpcMethodName);
                startTraceRequest.setSourceEventId(sourceEventId);
                startTraceRequest.setDomainId(domainId);
                startTraceRequest.setDomainType(domainType);
                startTraceRequest.setSampleFilter((SampleFilter)new GRPCSampleFilter());
                SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
                if (!TraceCollector.isSameDomain((String)domainId, (String)domainType)) {
                    envId = null;
                }
                Map<String, Object> collectorContext = SeverCollector.onStart(grpcMethodName, envId);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("spanEvent", spanEvent);
                map.put("gtraceId", TraceCollector.G_TRACE_ID_THREAD_LOCAL.get());
                map.put("userFlag", userFlag);
                map.put("serverCollectorContext", collectorContext);
                GRPCContext.TRACE_MAP_THREADLOCAL.set(map);
                if (args[0] instanceof TransformAccess) {
                    ((TransformAccess)args[0]).setLopsAttribute(map);
                }
                TraceCollector.clear();
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "streamCreated onStart error", (Throwable)ex);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

