/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.ClientObjectHolder;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsContext;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsRestClientCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.stats.EsClientStats;
import java.util.HashMap;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RestClient;

public class PerformRequestInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable()) {
                RestClient client = (RestClient)object;
                Integer num = ClientObjectHolder.getOrRegister(client);
                String clientNum = String.valueOf(num);
                Request request = (Request)args[0];
                String method = request.getMethod();
                String endpoint = request.getEndpoint();
                EsClientStats stats = EsRestClientCollector.onStart(clientNum, EsUtils.convertEndpoint(endpoint), method);
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"EsRestClient");
                HashMap<String, Object> context = new HashMap<String, Object>();
                if (EsRestClientCollector.isRestClientHighThanOrEqualTo70()) {
                    context.put("isFirst", Boolean.TRUE);
                } else {
                    context.put("spanEvent", spanEvent);
                    context.put("stats", (Object)stats);
                }
                context.put("url", endpoint);
                EsContext.TRACE_MAP_LOCAL.set(context);
            }
        }
        catch (Exception performRequestInterceptor) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)performRequestInterceptor);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                if (EsRestClientCollector.isRestClientHighThanOrEqualTo70()) {
                    EsRestClientCollector.onDefinitiveFailure();
                    EsRestClientCollector.onTrackFailure();
                    EsRestClientCollector.onException(e);
                }
            }
        }
        catch (Exception performRequestInterceptor) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)performRequestInterceptor);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable()) {
                EsRestClientCollector.onResponseClose();
                TraceCollector.onFinally();
                EsContext.TRACE_MAP_LOCAL.set(null);
            }
        }
        catch (Exception performRequestInterceptor) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)performRequestInterceptor);
        }
    }
}

