/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.elasticsearch.restclient.stats.EsClientStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EsClientAggregator
extends MultiPrimaryKeyAggregator<EsClientStats> {
    private static final String CLIENT_ID = "clientId";
    private static final String URL = "url";
    private static final String METHOD = "method";
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<EsClientStats> statsLocal = new ThreadLocal();

    public void parseParameters(Map<String, String> parameters) {
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> res = new HashMap<String, List<MonitorDataRow>>();
        ArrayList<MonitorDataRow> totalRowList = new ArrayList<MonitorDataRow>();
        long totalInvokeCount = 0L;
        long totalDefinitiveFailureCount = 0L;
        long totalRetryCount = 0L;
        long totalTotalTime = 0L;
        if (collected != null && !collected.isEmpty()) {
            for (MonitorDataRow row : collected) {
                Long invokeCount = (Long)row.get((Object)"invokeCount");
                Long definitiveFailureCount = (Long)row.get((Object)"definitiveFailureCount");
                Long retryCount = (Long)row.get((Object)"retryCount");
                Long totalTime = (Long)row.get((Object)"totalTime");
                if (invokeCount == null) {
                    invokeCount = 0L;
                }
                if (definitiveFailureCount == null) {
                    definitiveFailureCount = 0L;
                }
                if (retryCount == null) {
                    retryCount = 0L;
                }
                if (totalTime == null) {
                    totalTime = 0L;
                }
                totalInvokeCount += invokeCount.longValue();
                totalDefinitiveFailureCount += definitiveFailureCount.longValue();
                totalRetryCount += retryCount.longValue();
                totalTotalTime += totalTime.longValue();
            }
        }
        MonitorDataRow totalRow = new MonitorDataRow();
        totalRow.put((Object)"invokeCount", (Object)totalInvokeCount);
        totalRow.put((Object)"definitiveFailureCount", (Object)totalDefinitiveFailureCount);
        totalRow.put((Object)"retryCount", (Object)totalRetryCount);
        totalRow.put((Object)"totalTime", (Object)totalTotalTime);
        totalRowList.add(totalRow);
        res.put("total", totalRowList);
        return res;
    }

    public EsClientStats onStart(String clientId, String url, String method) {
        if (!this.isEnable) {
            return null;
        }
        EsClientStats stats = (EsClientStats)this.getValue(new String[]{clientId, url, method});
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
        return stats;
    }

    public Map<String, Object> onStartAsync(String clientId, String url, String method) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!this.isEnable) {
            return map;
        }
        EsClientStats stats = (EsClientStats)this.getValue(new String[]{clientId, url, method});
        if (stats != null) {
            map.put("startTime", stats.onStart());
            map.put("stats", (Object)stats);
        }
        return map;
    }

    public void onDefinitiveFailure() {
        if (!this.isEnable) {
            return;
        }
        EsClientStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onDefinitiveFailure(TraceCollector.getTraceId());
        }
    }

    public void onTrackFailure() {
        if (!this.isEnable) {
            return;
        }
        EsClientStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onTrackFailure();
        }
    }

    public void onDefinitiveFailureAsync(EsClientStats stats, String traceId) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null) {
            stats.onDefinitiveFailure(traceId);
        }
    }

    public void onTrackFailureAsync(EsClientStats stats) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null) {
            stats.onTrackFailure();
        }
    }

    public void onResponseClose() {
        if (!this.isEnable) {
            return;
        }
        EsClientStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
    }

    public void onResponseCloseAsync(Long startTime, EsClientStats stats, String traceId) {
        if (!this.isEnable) {
            return;
        }
        if (stats != null && startTime != null && stats.onFinally(System.nanoTime() - startTime)) {
            stats.setSlowTraceId(traceId);
        }
    }

    protected Class<EsClientStats> getValueType() {
        return EsClientStats.class;
    }

    protected int primaryKeyLength() {
        return 3;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(CLIENT_ID, URL, METHOD);
    }

    public String getName() {
        return "esClient";
    }
}

