/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.ProtectionDomain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static <T> boolean objectEqual(T s1, T s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String path, String content) throws IOException {
        FileOutputStream fileOutputStream = null;
        FilterOutputStream bufferedOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(new File(path));
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            bufferedOutputStream.write(content.getBytes("utf-8"));
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (bufferedOutputStream != null) {
                bufferedOutputStream.close();
            }
        }
    }

    public static String getHomePath() {
        String homePath = (String)System.getProperties().get("user.home");
        if (StringUtils.isBlank(homePath)) {
            homePath = "/tmp";
        }
        return homePath;
    }

    public static String getMD5String(String value) {
        if (value == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("md5");
            messageDigest.update(value.getBytes("utf8"));
            return Util.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (int j = 0; j < len; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }

    public static String readDubboAbstractInvokerInterceptorCode() {
        return Util.readClasspathFile("sentry.dubbo.AbstractInvoker.txt");
    }

    public static String readClasspathFile(String fileName) {
        BufferedReader br = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to read file:" + fileName, e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getInstanceNameByUserDir() {
        String userDir = System.getProperty("nuwa.home");
        if (userDir == null || "".equals(userDir)) {
            userDir = System.getProperty("catalina.home");
        }
        if (userDir == null || "".equals(userDir)) {
            userDir = System.getProperty("user.dir");
        }
        userDir = Util.filterUserDir(userDir);
        String instanceName = Util.getMD5String(userDir).substring(0, 3);
        instanceName = Util.checkInstanceNameByUserDir(userDir, instanceName);
        return instanceName;
    }

    public static String filterUserDir(String userDir) {
        String reg = "\\d{4,}";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(userDir);
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            userDir = userDir.substring(0, start) + userDir.substring(end);
            return Util.filterUserDir(userDir);
        }
        return userDir;
    }

    public static String checkInstanceNameByUserDir(String userDir, String instanceName) {
        String filePath = "/apm/instances/" + instanceName + "/user_dir.txt";
        String oldUseDir = FileUtils.readFile(filePath);
        if (oldUseDir == null || "".equals(oldUseDir)) {
            FileUtils.writeFile(filePath, userDir);
            return instanceName;
        }
        if (!oldUseDir.equals(userDir)) {
            instanceName = Util.getMD5String(userDir).substring(0, instanceName.length() + 1);
            return Util.checkInstanceNameByUserDir(userDir, instanceName);
        }
        return instanceName;
    }

    public static String getJarVersionFromProtectionDomain(ProtectionDomain protectionDomain) {
        String path = null;
        try {
            path = protectionDomain.getCodeSource().getLocation().getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path == null ? "unknown" : Util.getJarFileName(path);
    }

    private static String getJarFileName(String path) {
        int i = path.lastIndexOf("/");
        if (i < 0) {
            i = path.lastIndexOf("\\");
            if (path.endsWith("\\")) {
                i = path.lastIndexOf("\\", path.lastIndexOf("\\") - 1);
            }
        } else if (path.endsWith("/")) {
            i = path.lastIndexOf("/", path.lastIndexOf("/") - 1);
        }
        if (i > 0) {
            String jarFile = path.substring(i + 1);
            if (jarFile.endsWith("!/")) {
                jarFile = jarFile.replace("!/", "");
            }
            return jarFile;
        }
        return path;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            if (clazz != null) {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
            }
        }
        catch (NoSuchMethodException e) {
            method = Util.getMethod(clazz.getSuperclass(), methodName, parameterTypes);
        }
        catch (SecurityException e) {
            LogFactory.getLogger().log(Level.WARNING, "Failed to get method [" + methodName + "], " + e.getMessage(), e);
        }
        return method;
    }

    public static boolean isDocker() {
        String cgroupContent = FileUtils.readFile("/proc/self/cgroup");
        return cgroupContent.indexOf("docker") > -1;
    }
}

