/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.collector.interceptor.AggregatorAroundInterceptor;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;

public abstract class DefaultSinglePrimaryKeyAggregator
extends SinglePrimaryKeyAggregator<DefaultSectionStats>
implements AggregatorAroundInterceptor {
    private static ThreadLocal<DefaultSectionStats> statsLocal = new ThreadLocal();
    private static ThreadLocal<Long> timeLocal = new ThreadLocal();

    @Override
    protected Class<DefaultSectionStats> getValueType() {
        return DefaultSectionStats.class;
    }

    @Override
    public long onStart(String primaryKey) {
        if (!this.isEnable) {
            return 0L;
        }
        DefaultSectionStats stats = (DefaultSectionStats)this.getValue(primaryKey);
        long start = stats.onStart();
        statsLocal.set(stats);
        timeLocal.set(start);
        return start;
    }

    @Override
    public void onThrowable(Throwable t) {
        if (!this.isEnable) {
            return;
        }
        DefaultSectionStats stat = statsLocal.get();
        if (stat != null) {
            stat.onThrowable(t);
        }
    }

    @Override
    public long onFinally() {
        if (!this.isEnable) {
            return 0L;
        }
        DefaultSectionStats stat = statsLocal.get();
        Long start = timeLocal.get();
        if (stat != null && start != null) {
            long timeInNanos = System.nanoTime() - start;
            stat.onFinally(timeInNanos);
            statsLocal.set(null);
            timeLocal.set(null);
            return timeInNanos / 1000000L;
        }
        return 0L;
    }
}

