/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common;

import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultServerNodeStats;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import java.util.HashMap;
import java.util.Map;

public class DefaultServerNodeAggregator
extends SinglePrimaryKeyAggregator<DefaultServerNodeStats> {
    public static final String SERVER_ADDRESS = "serverAddr";
    public static final String ERROR_TAG = "serverAddrErr";
    public static final String TIME_USED_TAG = "serverAddrTimeUsed";
    private final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    private final ThreadLocal<DefaultServerNodeStats> statsLocal = new ThreadLocal();
    private final ThreadLocal<Boolean> errorLocal = new ThreadLocal();

    @Override
    public void parseParameters(Map<String, String> parameters) {
    }

    public void onStart(String serverAddr) {
        if (!this.isEnable) {
            return;
        }
        DefaultServerNodeStats stats = (DefaultServerNodeStats)this.getValue(serverAddr);
        long startTime = stats.onStart();
        this.statsLocal.set(stats);
        this.startTimeLocal.set(startTime);
    }

    public Boolean onError(String errorTraceId) {
        if (!this.isEnable) {
            return Boolean.FALSE;
        }
        DefaultServerNodeStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean onErrorAsync(String hostAddr, String errorTraceId) {
        if (!this.isEnable) {
            return Boolean.FALSE;
        }
        DefaultServerNodeStats stats = (DefaultServerNodeStats)this.getValue(hostAddr);
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Map<String, Object> onFinally() {
        if (!this.isEnable) {
            return null;
        }
        DefaultServerNodeStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (stats != null && startTime != null) {
            Long timeUsed = System.nanoTime() - startTime;
            if (stats.onFinally(timeUsed)) {
                stats.setSlowTraceId(TraceCollector.getTraceId());
            }
            Boolean hasError = this.errorLocal.get();
            res.put(TIME_USED_TAG, timeUsed);
            res.put(ERROR_TAG, hasError);
        }
        this.statsLocal.set(null);
        this.startTimeLocal.set(null);
        this.errorLocal.set(null);
        return res;
    }

    public Map<String, Object> onFinallyAsync(String hostAddr, Long startTime, String traceId) {
        if (!this.isEnable) {
            return null;
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (hostAddr != null && startTime != null) {
            Long timeUsed;
            DefaultServerNodeStats stats = (DefaultServerNodeStats)this.getValue(hostAddr);
            if (stats.onFinally(timeUsed = Long.valueOf(System.nanoTime() - startTime))) {
                stats.setSlowTraceId(traceId);
            }
            res.put(TIME_USED_TAG, timeUsed);
        }
        this.statsLocal.set(null);
        this.startTimeLocal.set(null);
        this.errorLocal.set(null);
        return res;
    }

    @Override
    protected Class<DefaultServerNodeStats> getValueType() {
        return DefaultServerNodeStats.class;
    }

    @Override
    public String getName() {
        return "serverNode";
    }

    @Override
    protected String primaryKey() {
        return SERVER_ADDRESS;
    }
}

