/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.apm;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.apm.ExceptionValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ExceptionAggregator
extends MultiPrimaryKeyAggregator<ExceptionValue> {
    public static final String AGGREGATE_KEY_TYPE = "type";
    public static final String AGGREGATE_KEY_CAUSE_TYPE = "causeType";
    public static final String AGGREGATE_METRIC_COUNT = "count";
    public static final String AGGREGATE_METRIC_MESSAGE = "message";
    public static final String AGGREGATE_METRIC_STACKTRACE = "stackTrace";

    @Override
    protected Class<ExceptionValue> getValueType() {
        return ExceptionValue.class;
    }

    public void onThrowable(String type, Throwable t) {
        Throwable c = t.getCause();
        String cause = c == null ? "NONE" : c.getClass().getName();
        ExceptionValue exceptionValue = (ExceptionValue)this.getValue(type, cause);
        exceptionValue.onThrowable(t);
    }

    @Override
    protected int primaryKeyLength() {
        return 2;
    }

    @Override
    protected List<String> primaryKey() {
        return Arrays.asList(AGGREGATE_KEY_TYPE, AGGREGATE_KEY_CAUSE_TYPE);
    }

    @Override
    public void parseParameters(Map<String, String> parameters) {
    }

    @Override
    public String getName() {
        return "exception";
    }

    @Override
    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }
}

