/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.collector.api;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.collector.api.AbstractPrimaryKeyValueAggregator;
import com.lubanops.apm.bootstrap.collector.api.MetricSet;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.LogPathUtils;
import com.lubanops.apm.bootstrap.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class Collector {
    private Map<String, MetricSetAggregator> aggrMap = new ConcurrentHashMap<String, MetricSetAggregator>();
    private boolean isEnable = false;
    private boolean isError = false;
    private int monitorItemId;
    private Map<String, String> parameters;

    public void register() {
        CollectorManager.register(this);
    }

    public Map<String, MetricSetAggregator> getModelAggregatorMap() {
        return this.aggrMap;
    }

    protected void addModelAggregator(MetricSetAggregator aggr) {
        if (aggr != null) {
            this.aggrMap.put(aggr.getName(), aggr);
        }
    }

    public void setMaxRow(int maxRow) {
        for (MetricSetAggregator modelAggregator : this.aggrMap.values()) {
            int oldMaxRow = modelAggregator.getMaxRowCount();
            modelAggregator.setMaxRowCount(maxRow);
            if (modelAggregator instanceof AbstractPrimaryKeyValueAggregator) {
                int size = ((AbstractPrimaryKeyValueAggregator)modelAggregator).size();
                if (size < maxRow && size < oldMaxRow) continue;
                modelAggregator.clear();
                continue;
            }
            if (oldMaxRow == maxRow) continue;
            modelAggregator.clear();
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters, String collectorName) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        if (parameters.equals(this.parameters)) {
            return;
        }
        this.parameters = parameters;
        try {
            String maxRowName = collectorName + "MaxRows";
            String maxRowStr = parameters.get(maxRowName);
            if (maxRowStr != null) {
                int maxRow = Integer.valueOf(maxRowStr);
                if (maxRow > 2000 || maxRow < 10) {
                    maxRow = ConfigManager.getMaxRow();
                }
                this.setMaxRow(maxRow);
            } else {
                this.setMaxRow(ConfigManager.getMaxRow());
            }
            this.parseParameter(parameters);
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "failed to parse parameter:" + parameters, e);
        }
        for (MetricSetAggregator msa : this.aggrMap.values()) {
            msa.setParameters(parameters);
        }
    }

    public abstract void parseParameter(Map<String, String> var1);

    public List<MetricSet> harvest() {
        ArrayList<MetricSet> result = new ArrayList<MetricSet>();
        for (MetricSetAggregator agg : this.aggrMap.values()) {
            Map<String, List<MonitorDataRow>> map;
            MetricSet metricSetItem = new MetricSet();
            List<MonitorDataRow> rows = agg.harvest();
            if (rows != null && !rows.isEmpty()) {
                metricSetItem.setDataRows(rows);
                metricSetItem.setName(agg.getName());
                result.add(metricSetItem);
            }
            if (agg.isFull()) {
                metricSetItem.setCode(1);
                StringBuilder sb = new StringBuilder();
                sb.append("row count exceeds the limitation:");
                sb.append(agg.getMaxRowCount());
                sb.append(",model:");
                sb.append(this.getCollectorName());
                sb.append(".");
                sb.append(agg.getName());
                metricSetItem.setMsg(sb.toString());
                metricSetItem.setName(agg.getName());
                this.dumpFull(agg, metricSetItem);
                result.add(metricSetItem);
            }
            if ((map = agg.afterHarvest(rows)) == null) continue;
            Set<Map.Entry<String, List<MonitorDataRow>>> set = map.entrySet();
            Iterator<Map.Entry<String, List<MonitorDataRow>>> itr = set.iterator();
            while (itr.hasNext()) {
                MetricSet afterMetricSetItem = new MetricSet();
                Map.Entry<String, List<MonitorDataRow>> entry = itr.next();
                afterMetricSetItem.setName(entry.getKey());
                afterMetricSetItem.setDataRows(entry.getValue());
                result.add(afterMetricSetItem);
            }
        }
        return result;
    }

    private void dumpFull(MetricSetAggregator agg, MetricSet metricSetItem) {
        try {
            if (!agg.isFullOutputted()) {
                LogFactory.getLogger().warning("aggregator is full,collector:" + this.getCollectorName() + ",aggr:" + agg.getName() + ",maxRows:" + agg.getMaxRowCount());
                agg.setFullOutputted(true);
                List<MonitorDataRow> dumped = agg.dump();
                if (dumped != null && !dumped.isEmpty()) {
                    String attachment = APIService.getJsonApi().toJSONString(dumped);
                    metricSetItem.setAttachment(attachment);
                    FileUtils.writeFile(LogPathUtils.getLogPath() + File.separator + "dumps" + File.separator + this.getCollectorName() + "&" + agg.getName(), attachment);
                } else {
                    LogFactory.getLogger().warning("dumped is empty for collector:" + this.getCollectorName() + ",aggr:" + agg.getName());
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "handle full error:" + this.getCollectorName() + ",aggr:" + agg.getName(), e);
        }
    }

    public boolean isEnable() {
        if (this.isError) {
            return false;
        }
        if (ConfigManager.isStopAgent()) {
            return false;
        }
        if (!ConfigManager.isValidated()) {
            return false;
        }
        return this.isEnable;
    }

    public void setEnable(boolean flag) {
        this.isEnable = flag;
        Collection<MetricSetAggregator> ll = this.aggrMap.values();
        if (ll != null && !ll.isEmpty()) {
            for (MetricSetAggregator agg : ll) {
                agg.setEnable(flag);
            }
        }
    }

    public boolean isCollectOnStart() {
        return false;
    }

    public abstract String getCollectorName();

    public int getMonitorItemId() {
        return this.monitorItemId;
    }

    public void setMonitorItemId(int monitorItemId) {
        this.monitorItemId = monitorItemId;
    }

    public boolean isError() {
        return this.isError;
    }

    public void setError(boolean isError) {
        this.isError = isError;
    }
}

