/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql5.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.mysql5.utils.Mysql5Utils;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.StatementImpl;

public class PreparedStatementExecuteUpdateInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String sql = Mysql5Utils.getSql(preparedStatement);
                String originSql = Mysql5Utils.getAsSql(preparedStatement);
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)preparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)sql, (String)originSql, (Integer)id);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "PreparedStatementExecuteUpdateInterceptor onStart", (Throwable)e);
        }
        return new Object[0];
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)object;
            String sql = Mysql5Utils.getSql(preparedStatement);
            Integer updateCount = Integer.valueOf(String.valueOf(result));
            MysqlCollector.onFinally((int)updateCount, (int)0);
            MysqlTrace.onFinally((int)updateCount, (int)0, null);
            MysqlCollector.onConnectionEnd((String)sql, (int)updateCount, (int)0);
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)object;
            String sql = Mysql5Utils.getSql(preparedStatement);
            PreparedStatementInteceptor.onError(sql, e);
            MysqlTrace.onError((Throwable)e);
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

