/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql5.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql5.interceptor.PreparedStatementInteceptor;
import com.lubanops.apm.plugin.mysql5.utils.Mysql5Utils;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSetImpl;
import com.mysql.jdbc.StatementImpl;

public class PreparedStatementExecuteQueryInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                String originSql = Mysql5Utils.getAsSql(preparedStatement);
                String sql = Mysql5Utils.getSql(preparedStatement);
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)preparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)sql, (String)originSql, (Integer)id);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)object;
            String sql = Mysql5Utils.getSql(preparedStatement);
            PreparedStatementInteceptor.onError(sql, e);
            MysqlTrace.onError((Throwable)e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            PreparedStatement preparedStatement = (PreparedStatement)object;
            String sql = Mysql5Utils.getSql(preparedStatement);
            int readRowCount = 0;
            ResultSetImpl resultSet = (ResultSetImpl)result;
            if (resultSet != null && (readRowCount = Integer.valueOf(String.valueOf(resultSet.getUpdateCount())).intValue()) == -1) {
                readRowCount = 1;
            }
            MysqlCollector.onConnectionEnd((String)sql, (int)0, (int)readRowCount);
            MysqlCollector.onFinally((int)0, (int)readRowCount);
            if (result != null && result instanceof TransformAccess) {
                MysqlTrace.onFinally((int)0, (int)readRowCount, (TransformAccess)((TransformAccess)result));
            } else {
                MysqlTrace.onFinally((int)0, (int)readRowCount, null);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
    }
}

