/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.thread;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.utils.ThreadUtils;
import java.lang.management.ThreadInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadStats
implements StatsBase {
    private String ids;
    private AtomicInteger count = new AtomicInteger(0);
    private Map<Long, Long> oldCpuTimes = new HashMap<Long, Long>();
    private Map<Long, Long> newCpuTimes = new HashMap<Long, Long>();
    private Map<Long, Long> oldMemoryMap = new HashMap<Long, Long>();
    private Map<Long, Long> newMemoryMap = new HashMap<Long, Long>();
    private AtomicLong cpuTime = new AtomicLong(0L);
    private AtomicLong memory = new AtomicLong(0L);
    private String stack;
    private int stateLevel = 0;

    public void setThreadInfo(ThreadInfo threadInfo, Integer maxFrames) {
        long id = threadInfo.getThreadId();
        this.setId(id);
        this.setStack(threadInfo, maxFrames);
        this.count.incrementAndGet();
        this.setCpuTime(id);
        this.setMemory(id);
    }

    public void setCpuTime(long id) {
        long newCpuTime = ThreadUtils.getCpuTime((long)id);
        if (newCpuTime == -1L) {
            return;
        }
        Long oldCpuTime = this.oldCpuTimes.get(id);
        this.newCpuTimes.put(id, newCpuTime);
        if (oldCpuTime != null) {
            this.cpuTime.addAndGet(newCpuTime - oldCpuTime);
        } else {
            this.cpuTime.addAndGet(newCpuTime);
        }
    }

    public void setId(long id) {
        if (this.ids == null) {
            this.ids = String.valueOf(id);
        } else if (this.ids.length() < 100) {
            this.ids = this.ids + "," + id;
        } else if (!this.ids.endsWith("...")) {
            this.ids = this.ids + "...";
        }
    }

    public void setMemory(long id) {
        long newMemory = ThreadUtils.getMemory((long)id);
        if (newMemory == -1L) {
            return;
        }
        Long oldMemory = this.oldMemoryMap.get(id);
        this.newMemoryMap.put(id, newMemory);
        if (oldMemory != null) {
            this.memory.addAndGet(newMemory - oldMemory);
        } else {
            this.memory.addAndGet(newMemory);
        }
    }

    public void setStack(ThreadInfo threadInfo, Integer maxFrames) {
        Thread.State threadState = threadInfo.getThreadState();
        if (this.stateLevel < 100) {
            if (this.stack == null || Thread.State.RUNNABLE.equals((Object)threadState) || Thread.State.BLOCKED.equals((Object)threadState)) {
                this.setStackLevel(threadInfo, threadState, maxFrames);
            }
        } else if (this.stateLevel < 200 && Thread.State.BLOCKED.equals((Object)threadState)) {
            this.setStackLevel(threadInfo, threadState, maxFrames);
        }
    }

    private void setStackLevel(ThreadInfo threadInfo, Thread.State threadState, Integer maxFrames) {
        this.stack = ThreadUtils.getThreadInfoString((ThreadInfo)threadInfo, (int)maxFrames);
        if (Thread.State.BLOCKED.equals((Object)threadState)) {
            this.stateLevel = 200;
        } else if (Thread.State.RUNNABLE.equals((Object)threadState)) {
            this.stateLevel = 100;
        }
    }

    public MonitorDataRow getStatus() {
        return null;
    }

    public MonitorDataRow harvest() {
        MonitorDataRow result = new MonitorDataRow();
        result.put((Object)"memory", (Object)this.memory.getAndSet(0L));
        result.put((Object)"stack", (Object)this.stack);
        result.put((Object)"ids", (Object)this.ids);
        result.put((Object)"cpuTime", (Object)(this.cpuTime.getAndSet(0L) / 1000000L));
        int threadCount = this.count.getAndSet(0);
        result.put((Object)"count", (Object)threadCount);
        this.oldCpuTimes = this.newCpuTimes;
        this.newCpuTimes = new HashMap<Long, Long>();
        this.oldMemoryMap = this.newMemoryMap;
        this.newMemoryMap = new HashMap<Long, Long>();
        this.stack = null;
        this.ids = null;
        this.stateLevel = 0;
        if (threadCount == 0) {
            return null;
        }
        return result;
    }
}

