/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.thread;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.utils.ThreadUtils;
import com.lubanops.apm.plugin.collector.thread.JVMThreadCollector;
import com.lubanops.apm.plugin.collector.thread.ThreadStats;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class JVMThreadDetailAggregator
extends SinglePrimaryKeyAggregator<ThreadStats> {
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    JVMThreadDetailAggregator() {
    }

    public String getName() {
        return "threadDetail";
    }

    protected String primaryKey() {
        return "threadName";
    }

    protected Class<ThreadStats> getValueType() {
        return ThreadStats.class;
    }

    public List<MonitorDataRow> harvest() {
        int limit = 30;
        ThreadInfo[] threadInfos = this.threadMXBean.getThreadInfo(this.threadMXBean.getAllThreadIds(), JVMThreadCollector.getMaxDepth() + 1);
        TreeMap<String, Integer> sortedMap = new TreeMap<String, Integer>();
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) continue;
            String name = ThreadUtils.getOriginThreadName((String)threadInfo.getThreadName());
            String threadName = this.getThreadName(name);
            sortedMap.merge(threadName, 1, Integer::sum);
        }
        if (sortedMap == null || sortedMap.size() == 0) {
            return super.harvest();
        }
        Set<Object> threadNameSet = new HashSet();
        if (sortedMap.size() > limit) {
            ArrayList sortedList = new ArrayList(sortedMap.entrySet());
            Collections.sort(sortedList, Map.Entry.comparingByValue(Comparator.reverseOrder()));
            for (int i = 0; i < limit; ++i) {
                threadNameSet.add(((Map.Entry)sortedList.get(i)).getKey());
            }
        } else {
            threadNameSet = sortedMap.keySet();
        }
        for (ThreadInfo threadInfo : threadInfos) {
            ThreadStats threadStats;
            String name;
            String threadName;
            if (threadInfo == null || !threadNameSet.contains(threadName = this.getThreadName(name = ThreadUtils.getOriginThreadName((String)threadInfo.getThreadName()))) || (threadStats = (ThreadStats)this.getValue(threadName)) == null) continue;
            threadStats.setThreadInfo(threadInfo, JVMThreadCollector.getMaxDepth());
        }
        return super.harvest();
    }

    private String getThreadName(String name) {
        return name.replaceAll("\\d+", "*");
    }
}

