/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.jvm;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.plugin.collector.jvm.JVMAggregatorEnum;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;

public class JVMThreadAggregator
extends NonePrimaryKeyAggregator {
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    JVMThreadAggregator() {
    }

    public String getName() {
        return JVMAggregatorEnum.thread.name();
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public MonitorDataRow constructItemRow() {
        MonitorDataRow row = new MonitorDataRow(8);
        row.put((Object)"threadCount", (Object)this.threadMXBean.getThreadCount());
        row.put((Object)"peakThreadCount", (Object)this.threadMXBean.getPeakThreadCount());
        this.threadMXBean.resetPeakThreadCount();
        row.put((Object)"daemonThreadCount", (Object)this.threadMXBean.getDaemonThreadCount());
        row.put((Object)"deadlockedThreadsCount", (Object)(this.threadMXBean.findDeadlockedThreads() == null ? 0 : this.threadMXBean.findDeadlockedThreads().length));
        row.put((Object)"totalStartedThreadCount", (Object)this.threadMXBean.getTotalStartedThreadCount());
        row.put((Object)"currentThreadCpuTime", (Object)this.threadMXBean.getCurrentThreadCpuTime());
        row.put((Object)"currentThreadUserTime", (Object)this.threadMXBean.getCurrentThreadUserTime());
        row.put((Object)"monitorDeadlockedThreads", (Object)(this.threadMXBean.findMonitorDeadlockedThreads() == null ? 0 : this.threadMXBean.findMonitorDeadlockedThreads().length));
        this.getThreadState(row);
        return row;
    }

    private void getThreadState(MonitorDataRow row) {
        ThreadInfo[] threadInfos = this.threadMXBean.getThreadInfo(this.threadMXBean.getAllThreadIds(), 0);
        int newCount = 0;
        int runnableCount = 0;
        int blockedCount = 0;
        int waitingCount = 0;
        int timedWaitingCount = 0;
        int terminatedCount = 0;
        block8: for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) continue;
            switch (threadInfo.getThreadState()) {
                case NEW: {
                    ++newCount;
                    continue block8;
                }
                case RUNNABLE: {
                    ++runnableCount;
                    continue block8;
                }
                case BLOCKED: {
                    ++blockedCount;
                    continue block8;
                }
                case WAITING: {
                    ++waitingCount;
                    continue block8;
                }
                case TIMED_WAITING: {
                    ++timedWaitingCount;
                    continue block8;
                }
                case TERMINATED: {
                    ++terminatedCount;
                    continue block8;
                }
            }
        }
        row.put((Object)"newThreadCount", (Object)newCount);
        row.put((Object)"runnableThreadCount", (Object)runnableCount);
        row.put((Object)"blockedThreadCount", (Object)blockedCount);
        row.put((Object)"waitingThreadCount", (Object)waitingCount);
        row.put((Object)"timedWaitingThreadCount", (Object)timedWaitingCount);
        row.put((Object)"terminatedThreadCount", (Object)terminatedCount);
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    public void clear() {
    }
}

