/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.jvm;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.plugin.collector.jvm.JVMAggregatorEnum;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JVMMemoryPoolAggregator
extends NonePrimaryKeyAggregator {
    private List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();

    JVMMemoryPoolAggregator() {
    }

    public String getName() {
        return JVMAggregatorEnum.memoryPool.name();
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        return this.constructItemRow();
    }

    public List<MonitorDataRow> harvest() {
        if (null == this.memoryPoolMXBeans || this.memoryPoolMXBeans.isEmpty()) {
            return null;
        }
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>(this.memoryPoolMXBeans.size());
        for (MemoryPoolMXBean bean : this.memoryPoolMXBeans) {
            MemoryUsage memoryUsage = bean.getUsage();
            MonitorDataRow row = new MonitorDataRow();
            row.put((Object)"name", (Object)bean.getName());
            row.put((Object)"committed", (Object)memoryUsage.getCommitted());
            row.put((Object)"init", (Object)memoryUsage.getInit());
            row.put((Object)"max", (Object)memoryUsage.getMax());
            row.put((Object)"used", (Object)memoryUsage.getUsed());
            result.add(row);
        }
        return result;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public MonitorDataRow constructItemRow() {
        return null;
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    public void clear() {
    }
}

