/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.jvm;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.collector.jvm.JVMAggregatorEnum;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class JVMMemoryAggregator
extends NonePrimaryKeyAggregator {
    private static final String DIRECT_OBJECT_NAME = "java.nio:type=BufferPool,name=direct";
    private static final String MEMORY_USAGE_ATTRIBUTE_NAME = "MemoryUsed";
    private static final String MEMORY_CAPACITY_ATTRIBUTE_NAME = "TotalCapacity";
    private MemoryMXBean memoryMbean;
    private ObjectName directMemoryBean;
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    JVMMemoryAggregator() {
        this.memoryMbean = ManagementFactory.getMemoryMXBean();
        Set<ObjectName> objectNames = null;
        try {
            objectNames = this.server.queryNames(new ObjectName(DIRECT_OBJECT_NAME), null);
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "Failed to get directMemoryBean, " + e.getMessage(), (Throwable)e);
        }
        if (objectNames != null && !objectNames.isEmpty()) {
            this.directMemoryBean = objectNames.iterator().next();
        }
    }

    public String getName() {
        return JVMAggregatorEnum.memory.name();
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public MonitorDataRow constructItemRow() {
        MonitorDataRow row = new MonitorDataRow();
        row.put((Object)"heapMemoryUsage", (Object)this.memoryMbean.getHeapMemoryUsage().getUsed());
        row.put((Object)"nonHeapMemoryUsage", (Object)this.memoryMbean.getNonHeapMemoryUsage().getUsed());
        row.put((Object)"objectPendingFinalizationCount", (Object)this.memoryMbean.getObjectPendingFinalizationCount());
        if (this.directMemoryBean != null) {
            try {
                row.put((Object)"directMemoryUsage", this.server.getAttribute(this.directMemoryBean, MEMORY_USAGE_ATTRIBUTE_NAME));
                row.put((Object)"directMemoryCapacity", this.server.getAttribute(this.directMemoryBean, MEMORY_CAPACITY_ATTRIBUTE_NAME));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return row;
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    public void clear() {
    }
}

