/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.gc;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.NonePrimaryKeyAggregator;
import com.lubanops.apm.plugin.collector.gc.JVMGcAggregatorEnum;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JVMGcAggregator
extends NonePrimaryKeyAggregator {
    private static final String[] FGC_NAME_ARR = new String[]{"ConcurrentMarkSweep", "MarkSweepCompact", "PS MarkSweep", "G1 Old Generation", "Garbage collection optimized for short pausetimes Old Collector", "Garbage collection optimized for throughput Old Collector", "Garbage collection optimized for deterministic pausetimes Old Collector"};
    private static final Set<String> FGC_NAME_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(FGC_NAME_ARR)));
    private static final String[] YGC_NAME_ARR = new String[]{"ParNew", "Copy", "PS Scavenge", "G1 Young Generation", "Garbage collection optimized for short pausetimes Young Collector", "Garbage collection optimized for throughput Young Collector", "Garbage collection optimized for deterministic pausetimes Young Collector"};
    private static final Set<String> YGC_NAME_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(YGC_NAME_ARR)));
    private GarbageCollectorMXBeanWrapper fullGC;
    private GarbageCollectorMXBeanWrapper youngGC;

    JVMGcAggregator() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean item : garbageCollectorMXBeans) {
            if (FGC_NAME_SET.contains(item.getName())) {
                this.fullGC = new GarbageCollectorMXBeanWrapper(item);
                continue;
            }
            if (!YGC_NAME_SET.contains(item.getName())) continue;
            this.youngGC = new GarbageCollectorMXBeanWrapper(item);
        }
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        return this.constructItemRowInternal(false);
    }

    public String getName() {
        return JVMGcAggregatorEnum.gc.name();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public List<MonitorDataRow> getAllStatus() {
        MonitorDataRow row = this.constructItemRowInternal(false);
        return row == null ? null : Collections.singletonList(row);
    }

    public void clear() {
    }

    public MonitorDataRow constructItemRow() {
        return this.constructItemRowInternal(true);
    }

    private MonitorDataRow constructItemRowInternal(boolean reset) {
        MonitorDataRow row = new MonitorDataRow(10);
        if (this.youngGC != null) {
            row.put((Object)"youngGCMBeanName", (Object)this.youngGC.getName());
            row.put((Object)"youngGCCount", (Object)this.youngGC.getIncrementCount(reset));
            row.put((Object)"youngGCTime", (Object)this.youngGC.getIncrementTime(reset));
            row.put((Object)"youngGCCountTotal", (Object)this.youngGC.getTotalCount());
            row.put((Object)"youngGCTimeTotal", (Object)this.youngGC.getTotalTime());
        }
        if (this.fullGC != null) {
            row.put((Object)"fullGCMBeanName", (Object)this.fullGC.getName());
            row.put((Object)"fullGCCount", (Object)this.fullGC.getIncrementCount(reset));
            row.put((Object)"fullGCTime", (Object)this.fullGC.getIncrementTime(reset));
            row.put((Object)"fullGCCountTotal", (Object)this.fullGC.getTotalCount());
            row.put((Object)"fullGCTimeTotal", (Object)this.fullGC.getTotalTime());
        }
        return row;
    }

    static final class GarbageCollectorMXBeanWrapper {
        final GarbageCollectorMXBean bean;
        private long lastGCCount;
        private long lastGCTime;

        GarbageCollectorMXBeanWrapper(GarbageCollectorMXBean garbageCollectorMXBean) {
            this.bean = garbageCollectorMXBean;
        }

        String getName() {
            return this.bean.getName();
        }

        long getTotalCount() {
            return this.bean.getCollectionCount();
        }

        long getTotalTime() {
            return this.bean.getCollectionTime();
        }

        long getIncrementCount(boolean reset) {
            long newGCCount = this.getTotalCount();
            if (this.lastGCCount == -1L) {
                this.lastGCCount = newGCCount;
                return newGCCount;
            }
            long result = newGCCount - this.lastGCCount;
            if (reset) {
                this.lastGCCount = newGCCount;
            }
            return result;
        }

        long getIncrementTime(boolean reset) {
            long newGCTime = this.getTotalTime();
            if (this.lastGCTime == -1L) {
                this.lastGCTime = newGCTime;
                return newGCTime;
            }
            long result = newGCTime - this.lastGCTime;
            if (reset) {
                this.lastGCTime = newGCTime;
            }
            return result;
        }
    }
}

