/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.spring.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodCollector;
import com.lubanops.apm.plugin.spring.collector.SpringBeanMethodPattern;

public class ApplyBeanPostProcessorInterceptor
implements Interceptor {
    private static final Logger LOGGER = LogFactory.getLogger();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (!AgentConfigManager.isTransformSpringBean()) {
            return;
        }
        try {
            if (result == null) {
                return;
            }
            Class<?> beanClass = result.getClass();
            if (beanClass == null) {
                return;
            }
            SpringBeanMethodPattern methodPattern = new SpringBeanMethodPattern();
            methodPattern.setClassName(beanClass.getName());
            SpringBeanMethodCollector.getInstance().retransForm(methodPattern, beanClass);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "ApplyBeanPostProcessorInterceptor onFinally", (Throwable)e);
            return;
        }
    }
}

