/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jettyclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientType;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.jettyclient.JettyClientUtils;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.client.HttpRequest;

public class SendInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            HttpRequest request;
            if (HttpClientCollector.INSTANCE.isEnable() && args[0] instanceof HttpRequest && (request = (HttpRequest)args[0]) instanceof TransformAccess) {
                String scheme = request.getScheme();
                String host = request.getHost();
                int port = request.getPort();
                String path = request.getPath();
                String httpMethod = JettyClientUtils.getMethod(request);
                String hostUri = scheme + "://" + host + ":" + port;
                String requestUri = hostUri + path;
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)HttpClientType.JettyClient.name());
                TraceCollector.onFinally((boolean)false);
                Map context = HttpClientCollector.onStartAsync((String)hostUri, (String)requestUri, (String)httpMethod, (String)HttpClientType.Jdkhttpclient.name());
                context.put("url", requestUri);
                if (spanEvent != null) {
                    spanEvent.addTag("url", requestUri);
                    spanEvent.addTag("httpMethod", httpMethod);
                    context.put("spanevent", spanEvent);
                }
                ((TransformAccess)request).setLopsAttribute((Object)context);
                this.setHeaders(request, spanEvent);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return new Object[0];
    }

    private void setHeaders(HttpRequest request, SpanEvent spanEvent) {
        List txName;
        String userFlag;
        String gTraceId;
        request.header(Headers.ENV_ID.getValue(), String.valueOf(IdentityConfigManager.getEnvId()));
        request.header(Headers.DOMAIN_ID.getValue(), String.valueOf(IdentityConfigManager.getDomainId()));
        request.header(Headers.DOMAIN_TYPE.getValue(), String.valueOf(IdentityConfigManager.getDomainType()));
        if (spanEvent != null) {
            String nextSpanId = spanEvent.generateNextSpanId();
            String traceId = spanEvent.getTraceId();
            request.header(Headers.TRACE_ID.getValue(), traceId);
            request.header(Headers.SPAN_ID.getValue(), nextSpanId);
            request.header(Headers.SOURCE_EVENT_ID.getValue(), spanEvent.getEventId());
        }
        if (!StringUtils.isBlank((String)(gTraceId = TraceCollector.getVirtualTraceId()))) {
            request.header(Headers.GTRACE_ID.getValue(), gTraceId);
        }
        if (!StringUtils.isBlank((String)(userFlag = TraceCollector.getUserFlag()))) {
            request.header(Headers.USER_FLAG.getValue(), userFlag);
        }
        if ((txName = TransactionCollector.getTxName()) != null && txName.size() > 0) {
            request.header(Headers.TXNANE_ID.getValue(), StringUtils.joinTxList((CharSequence)",", (List)txName));
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

