/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql8.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.plugin.mysql8.interceptor.PreparedStatementInteceptor;
import com.mysql.cj.PreparedQuery;
import com.mysql.cj.jdbc.ClientPreparedStatement;
import com.mysql.cj.jdbc.StatementImpl;
import java.sql.SQLException;

public class PreparedStatementExecuteUpdateInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                ClientPreparedStatement preparedStatement = (ClientPreparedStatement)object;
                String preparedSql = preparedStatement.getPreparedSql();
                Integer id = PreparedStatementInteceptor.getConnectionId((StatementImpl)preparedStatement);
                PreparedStatementInteceptor.onStart(preparedSql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)preparedSql, (String)this.getOriginSql(preparedStatement), (Integer)id);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "PreparedStatementExecuteUpdateInterceptor error", (Throwable)ex);
        }
        return new Object[0];
    }

    private String getOriginSql(ClientPreparedStatement mysql8PreparedStatement) throws SQLException {
        try {
            return mysql8PreparedStatement.asSql();
        }
        catch (NoSuchMethodError e) {
            return ((PreparedQuery)mysql8PreparedStatement.getQuery()).asSql();
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                ClientPreparedStatement preparedStatement = (ClientPreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                PreparedStatementInteceptor.onError(sql, e);
                MysqlTrace.onError((Throwable)e);
            }
        }
        catch (Exception exception) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)exception);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable()) {
                ClientPreparedStatement preparedStatement = (ClientPreparedStatement)object;
                String sql = preparedStatement.getPreparedSql();
                Integer updateCount = Integer.valueOf(String.valueOf(result));
                MysqlCollector.onFinally((int)updateCount, (int)0);
                MysqlTrace.onFinally((int)updateCount, (int)0, null);
                MysqlCollector.onConnectionEnd((String)sql, (int)updateCount, (int)0);
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

