/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mysql8.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.utils.Util;
import com.mysql.cj.jdbc.ConnectionImpl;
import java.security.ProtectionDomain;

public class MysqlConnectionInterceptor
implements Interceptor {
    public MysqlConnectionInterceptor() {
        MysqlCollector.setDriverVersion((String)Util.getJarVersionFromProtectionDomain((ProtectionDomain)ConnectionImpl.class.getProtectionDomain()));
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            ConnectionImpl connection = (ConnectionImpl)object;
            String mysqldbName = Helper.getDbName((String)connection.getHostPortPair(), (String)connection.getCatalog());
            Integer id = Helper.CONNECTION_TARGET_MAP.registerResource(mysqldbName);
            if (object instanceof TransformAccess) {
                ((TransformAccess)object).setLopsAttribute((Object)id);
            }
            MysqlCollector.onConnectionCreated((Integer)id);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }
}

