/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.interceptor;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;
import com.mongodb.connection.ServerType;

public class ServerRunCommandInterceptor {
    public static void onStart(String serverAddr, ServerType serverType) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                MongoDbCollector.nodeOnStart(serverAddr, serverType);
                if (spanEvent != null) {
                    spanEvent.addTag("ServerAddress", serverAddr);
                    spanEvent.addTag("ServerType", serverType.name());
                }
            }
        }
        catch (Exception serverRunCommandException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)serverRunCommandException);
        }
    }

    public static void onError() {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                MongoDbCollector.nodeOnError(TraceCollector.getTraceId());
            }
        }
        catch (Exception serverRunCommandException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)serverRunCommandException);
        }
    }

    public static void onFinally() {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                MongoDbCollector.nodeOnFinally();
            }
        }
        catch (Exception serverRunCommandException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)serverRunCommandException);
        }
    }
}

