/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.collector.method;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaMethodAggregator
extends MultiPrimaryKeyAggregator<DefaultSectionStats> {
    public String getName() {
        return "method";
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("class", "method");
    }

    protected Class<DefaultSectionStats> getValueType() {
        return DefaultSectionStats.class;
    }

    public void parseParameters(Map<String, String> parameters) {
        int[] range;
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        if ((range = (int[])ParameterParseUtil.getParameterValue(parameters, (String)"methodRange", int[].class)) != null && range.length == 5) {
            this.setRanges(range);
        } else {
            this.setRanges(new int[]{10, 100, 500, 1000, 10000});
        }
    }

    public void onStart(String className, String method) {
        if (!this.isEnable) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{className, method});
        DefaultSectionStats stats = (DefaultSectionStats)this.getValue(pk);
        stats.onStart();
    }

    public void onThrowable(String className, String method, Throwable th) {
        if (!this.isEnable) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{className, method});
        DefaultSectionStats stats = (DefaultSectionStats)this.getValue(pk);
        if (stats != null) {
            stats.onThrowable(th);
        }
    }

    public void onFinally(String className, String method, long timeUsed) {
        if (!this.isEnable) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{className, method});
        DefaultSectionStats stats = (DefaultSectionStats)this.getValue(pk);
        if (stats != null) {
            stats.onFinally(timeUsed);
        }
    }

    protected int primaryKeyLength() {
        return 2;
    }
}

