/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mqtt.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.plugin.mqtt.stats.MqttPublishStats;
import com.lubanops.apm.bootstrap.plugin.mqtt.stats.MqttReceiveStats;

public class MqttTopicStats
extends UrlStats {
    private final MqttPublishStats publishStats = new MqttPublishStats();
    private final MqttReceiveStats receiveStats = new MqttReceiveStats();

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        if (row != null) {
            MonitorDataRow publishRow = this.publishStats.getStatus();
            MonitorDataRow receiveRow = this.receiveStats.getStatus();
            row.put((Object)"msgReceivedCount", receiveRow.get((Object)"msgReceivedCount"));
            row.put((Object)"msgSentCount", publishRow.get((Object)"msgSentCount"));
            row.put((Object)"bytesReceived", receiveRow.get((Object)"bytesReceived"));
            row.put((Object)"bytesSent", publishRow.get((Object)"bytesSent"));
        }
        return row;
    }

    public MonitorDataRow harvest() {
        MonitorDataRow row = super.harvest();
        if (row == null) {
            row = new MonitorDataRow();
        }
        MonitorDataRow publishRow = this.publishStats.harvest();
        MonitorDataRow receiveRow = this.receiveStats.harvest();
        row.put((Object)"msgReceivedCount", receiveRow.get((Object)"msgReceivedCount"));
        row.put((Object)"msgSentCount", publishRow.get((Object)"msgSentCount"));
        row.put((Object)"bytesReceived", receiveRow.get((Object)"bytesReceived"));
        row.put((Object)"bytesSent", publishRow.get((Object)"bytesSent"));
        return row;
    }

    public void onReceiveMsg(int bytesCount) {
        this.receiveStats.onReceiveMsg(bytesCount);
    }

    public void onSendMsg(int bytesCount) {
        this.publishStats.onSendMsg(bytesCount);
    }
}

