/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mqtt.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultStats;
import java.util.concurrent.atomic.AtomicLong;

public class MqttReceiveStats
extends DefaultStats {
    public static final String MESSAGE_RECEIVED_COUNT = "msgReceivedCount";
    public static final String BYTES_RECEIVED = "bytesReceived";
    protected final AtomicLong msgReceivedCount = new AtomicLong(0L);
    protected final AtomicLong bytesReceived = new AtomicLong(0L);
    protected volatile long msgReceivedCountCountOld;
    protected volatile long bytesReceivedOld;

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        if (row != null) {
            row.put((Object)MESSAGE_RECEIVED_COUNT, (Object)this.msgReceivedCount);
            row.put((Object)BYTES_RECEIVED, (Object)this.bytesReceived);
        }
        return row;
    }

    public MonitorDataRow harvest() {
        MonitorDataRow row = super.harvest();
        if (row == null) {
            row = new MonitorDataRow();
        }
        long msgReceivedCountNew = this.msgReceivedCount.get();
        long bytesReceivedNew = this.bytesReceived.get();
        row.put((Object)MESSAGE_RECEIVED_COUNT, (Object)(msgReceivedCountNew - this.msgReceivedCountCountOld));
        row.put((Object)BYTES_RECEIVED, (Object)(bytesReceivedNew - this.bytesReceivedOld));
        this.msgReceivedCountCountOld = msgReceivedCountNew;
        this.bytesReceivedOld = bytesReceivedNew;
        return row;
    }

    public void onReceiveMsg(int bytesCount) {
        this.msgReceivedCount.incrementAndGet();
        this.bytesReceived.addAndGet(bytesCount);
    }
}

