/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.druid.collector;

import com.alibaba.druid.pool.DruidDataSource;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.plugin.druid.collector.DruidDBConnectionAggregator;
import com.lubanops.apm.plugin.druid.collector.DruidDataSourceAggregator;
import java.util.Map;

public class DruidCollector
extends Collector {
    public static final DruidCollector INSTANCE = new DruidCollector();
    private static final DruidDataSourceAggregator DRUID_DATA_SOURCE_AGGREGATOR = new DruidDataSourceAggregator();
    private static final DruidDBConnectionAggregator DRUID_DB_CONNECTION_AGGREGATOR = new DruidDBConnectionAggregator();
    private static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    private static final DefaultVersionAggregator DEFAULT_VERSION_AGGREGATOR = new DefaultVersionAggregator();

    public void parseParameter(Map<String, String> parameters) {
        DRUID_DB_CONNECTION_AGGREGATOR.parseParameters(parameters);
    }

    public static void onStart(DruidDataSource dataSource) {
        DRUID_DB_CONNECTION_AGGREGATOR.onStart(dataSource.getRawJdbcUrl());
    }

    public static void onThrowable(Throwable t) {
        DRUID_DB_CONNECTION_AGGREGATOR.onThrowable(t);
        EXCEPTION_AGGREGATOR.onThrowable(t);
    }

    public static void onFinally() {
        DRUID_DB_CONNECTION_AGGREGATOR.onFinally();
    }

    public static void setDriverVersion(String driverVersion) {
        DEFAULT_VERSION_AGGREGATOR.setVersion(driverVersion);
    }

    public int getTimeSpanThreshold() {
        return DRUID_DB_CONNECTION_AGGREGATOR.getTimeSpanThreshold();
    }

    public boolean isGetPoolInfo() {
        return DRUID_DB_CONNECTION_AGGREGATOR.isGetPoolInfo();
    }

    public String getCollectorName() {
        return "Druid";
    }

    public Integer getActiveCount() {
        return DRUID_DB_CONNECTION_AGGREGATOR.getActiveCount();
    }

    public Integer getPoolingCount() {
        return DRUID_DB_CONNECTION_AGGREGATOR.getPoolingCount();
    }

    public Integer getWaitThreadCount() {
        return DRUID_DB_CONNECTION_AGGREGATOR.getWaitThreadCount();
    }

    public void setCounts(int activeCount, int poolingCount, int waitThreadCount) {
        DRUID_DB_CONNECTION_AGGREGATOR.setCounts(activeCount, poolingCount, waitThreadCount);
    }

    public void clearCounts() {
        DRUID_DB_CONNECTION_AGGREGATOR.clearCounts();
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)DRUID_DATA_SOURCE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)DRUID_DB_CONNECTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)DEFAULT_VERSION_AGGREGATOR);
        INSTANCE.register();
    }
}

