/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.utils;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.core.utils.MyConnectionSocketFactory;
import com.lubanops.apm.core.utils.MySSLConnectionSocketFactory;
import com.lubanops.apm.integration.enums.HttpMethod;
import com.lubanops.apm.integration.transport.http.HttpRequest;
import com.lubanops.apm.integration.transport.http.HttpSigner;
import com.lubanops.apm.integration.transport.http.Request;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    public static final PoolingHttpClientConnectionManager CONN_MANAGER;
    public static final CloseableHttpClient HTTP_CLIENT;
    public static final HttpSigner HTTP_SIGNER;
    public static final String SOCKS_ADDRESS = "socks.address";
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result sendPostJSON(String url, String encoding, String content, int timeout) throws Exception {
        Result result;
        CloseableHttpResponse closeableHttpResponse;
        block13: {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
            HttpRequest request = HttpClientUtil.buildSignedRequest(url, content);
            HttpPost httpPost = (HttpPost)request.generate();
            httpPost.setConfig(requestConfig);
            HttpEntity entity = null;
            closeableHttpResponse = null;
            try {
                closeableHttpResponse = HTTP_CLIENT.execute((HttpUriRequest)httpPost);
                StatusLine st = closeableHttpResponse.getStatusLine();
                entity = closeableHttpResponse.getEntity();
                String resultStr = EntityUtils.toString((HttpEntity)entity, (String)encoding);
                result = new Result(st.getStatusCode(), resultStr);
                if (entity == null) break block13;
            }
            catch (Throwable throwable) {
                if (entity != null) {
                    try {
                        EntityUtils.consume(entity);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "", (Throwable)e);
                    }
                }
                if (closeableHttpResponse != null) {
                    try {
                        closeableHttpResponse.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "", (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "", (Throwable)e);
            }
        }
        if (closeableHttpResponse != null) {
            try {
                closeableHttpResponse.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result sendPostJSONProxy(String url, String encoding, String content, int timeout, String proxy) throws Exception {
        Result result;
        CloseableHttpResponse httpResponse;
        block13: {
            String[] hostAndPort = proxy.split(":");
            InetSocketAddress socksAddr = new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
            HttpRequest request = new HttpRequest();
            request.setMethod(HttpMethod.POST.name());
            request.setUrl(url);
            request.addHeader("Content-type", "application/json; charset=utf-8");
            request.setBody(content);
            HTTP_SIGNER.sign((Request)request);
            HttpPost httpPost = (HttpPost)request.generate();
            httpPost.setConfig(requestConfig);
            HttpEntity proxyEntity = null;
            httpResponse = null;
            try {
                HttpClientContext context = HttpClientContext.create();
                context.setAttribute(SOCKS_ADDRESS, (Object)socksAddr);
                httpResponse = HTTP_CLIENT.execute((HttpUriRequest)httpPost, (HttpContext)context);
                StatusLine st = httpResponse.getStatusLine();
                proxyEntity = httpResponse.getEntity();
                String resultString = EntityUtils.toString((HttpEntity)proxyEntity, (String)encoding);
                result = new Result(st.getStatusCode(), resultString);
                if (proxyEntity == null) break block13;
            }
            catch (Throwable throwable) {
                if (proxyEntity != null) {
                    try {
                        EntityUtils.consume(proxyEntity);
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "", (Throwable)e);
                    }
                }
                if (httpResponse != null) {
                    try {
                        httpResponse.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.SEVERE, "", (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                EntityUtils.consume((HttpEntity)proxyEntity);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "", (Throwable)e);
            }
        }
        if (httpResponse != null) {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "", (Throwable)e);
            }
        }
        return result;
    }

    private static HttpRequest buildSignedRequest(String url, String content) throws Exception {
        HttpRequest request = new HttpRequest();
        request.setMethod(HttpMethod.POST.name());
        request.setUrl(url);
        request.addHeader("Content-type", "application/json; charset=utf-8");
        request.setBody(content);
        HTTP_SIGNER.sign((Request)request);
        return request;
    }

    public static Result sendPostToServer(List<String> addressList, String[] proxyList, String url, String params) {
        Collections.shuffle(addressList);
        Exception exception = null;
        Result response = null;
        for (String masterAddress : addressList) {
            if (proxyList != null && proxyList.length > 0) {
                List<String> proxyIpList = Arrays.asList(proxyList);
                Collections.shuffle(proxyIpList);
                for (String proxy : proxyIpList) {
                    try {
                        LOGGER.log(Level.INFO, "proxy: " + proxy);
                        response = HttpClientUtil.sendPostJSONProxy(masterAddress + url, "utf-8", params, 3000, proxy);
                        if (response.getStatus() != 200) continue;
                        return response;
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                }
                continue;
            }
            try {
                response = HttpClientUtil.sendPostJSON(masterAddress + url, "utf-8", params, 3000);
                if (response.getStatus() != 200) continue;
                return response;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (response != null) {
            return response;
        }
        if (exception != null) {
            LOGGER.log(Level.SEVERE, url + " error", (Throwable)exception);
        }
        return response;
    }

    static {
        LOGGER = LogFactory.getLogger();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)MyConnectionSocketFactory.getSocketFactory()).register("https", (Object)MySSLConnectionSocketFactory.getSocketFactory()).build();
        CONN_MANAGER = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        CONN_MANAGER.setDefaultMaxPerRoute(1);
        CONN_MANAGER.setMaxTotal(1);
        CONN_MANAGER.closeIdleConnections(1L, TimeUnit.MILLISECONDS);
        HTTP_CLIENT = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)CONN_MANAGER).setConnectionReuseStrategy(new ConnectionReuseStrategy(){

            public boolean keepAlive(HttpResponse response, HttpContext context) {
                return false;
            }
        }).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).build();
        HTTP_SIGNER = new HttpSigner();
    }

    public static class Result {
        private int status;
        private String content;

        Result(int status, String content) {
            this.status = status;
            this.content = content;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String toString() {
            return "[" + this.status + "][" + this.content + "]";
        }
    }
}

