/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.utils;

import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.core.utils.ParamsUtils;
import java.util.Map;

public class AgentPath {
    public static final String AGENT_PATH_COMMONS = "agentPath";
    public static final String BOOT_PATH_COMMONS = "bootPath";
    public static final String PLUGINS_PATH_COMMONS = "pluginsPath";
    private static AgentPath instance;
    private String agentPath;
    private String bootPath;
    private String pluginsPath;

    private AgentPath() {
    }

    public static AgentPath getInstance() {
        if (null == instance) {
            throw new ApmRuntimeException("[APM BOOTSTRAP]AgentPath has not instantiated.");
        }
        return instance;
    }

    public static AgentPath build(Map argsMap) {
        AgentPath agentPath = new AgentPath();
        agentPath.setAgentPath(argsMap.get(AGENT_PATH_COMMONS).toString());
        agentPath.setBootPath(argsMap.get(BOOT_PATH_COMMONS).toString());
        agentPath.setPluginsPath(argsMap.get(PLUGINS_PATH_COMMONS).toString());
        agentPath.checkIntegrity();
        instance = agentPath;
        return instance;
    }

    private void checkIntegrity() {
        ParamsUtils.checkArgument(this.agentPath);
        ParamsUtils.checkArgument(this.bootPath);
        ParamsUtils.checkArgument(this.pluginsPath);
    }

    public String getAgentPath() {
        return this.agentPath;
    }

    public void setAgentPath(String agentPath) {
        this.agentPath = agentPath;
    }

    public String getBootPath() {
        return this.bootPath;
    }

    public void setBootPath(String bootPath) {
        this.bootPath = bootPath;
    }

    public String getPluginsPath() {
        return this.pluginsPath;
    }

    public void setPluginsPath(String pluginsPath) {
        this.pluginsPath = pluginsPath;
    }
}

