/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.update;

import com.lubanops.apm.bootstrap.collector.UpdataListenerManager;
import com.lubanops.apm.bootstrap.collector.UpdateListener;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import java.util.Iterator;

public class UpdateThread
extends Thread {
    private static final Logger LOG = LogFactory.getLogger();
    private static UpdateThread instance = new UpdateThread();
    private int sleepInterval = 5;

    private UpdateThread() {
        super("LubanopsUpdateThread");
        if (this.sleepInterval <= 1) {
            LOG.warning("invalid update thread Interval:" + this.sleepInterval + ",using default value:10");
            this.sleepInterval = 10;
        }
        this.setDaemon(true);
    }

    public static UpdateThread getInstance() {
        return instance;
    }

    @Override
    public void run() {
        LOG.info("UpdateThread started!");
        try {
            block4: while (true) {
                Thread.sleep(this.sleepInterval * 1000);
                Iterator iterator = UpdataListenerManager.LISTENER_LIST.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    UpdateListener ul = (UpdateListener)iterator.next();
                    try {
                        ul.update();
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "failed to execute update", (Throwable)e);
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            LOG.info("update thread exit!");
            return;
        }
    }

    public void shutdown() {
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, "failed to join", (Throwable)e);
        }
    }
}

