/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.transformer;

import com.lubanops.apm.bootstrap.utils.FileUtils;
import com.lubanops.apm.core.transformer.Transformer;
import com.lubanops.apm.core.utils.AgentPath;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

public class TransformerManager {
    private static Instrumentation instrumentation;
    private static final String ABSTRACT_LOGGER = "org.apache.logging.log4j.spi.AbstractLogger";
    private static final String CLASSIC_LOGGER = "ch.qos.logback.classic.Logger";

    public static void init(Instrumentation instrumentation) {
        TransformerManager.setInstrumentation(instrumentation);
        final List plugins = FileUtils.getLibUrl((String)AgentPath.getInstance().getPluginsPath());
        URLClassLoader pluginClassLoader = (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new URLClassLoader(plugins.toArray(new URL[plugins.size()]), null);
            }
        });
        instrumentation.addTransformer(new Transformer(pluginClassLoader), true);
        TransformerManager.retransformClasses(instrumentation);
    }

    private static void retransformClasses(Instrumentation instrumentation) {
        for (Class loadedClass : instrumentation.getAllLoadedClasses()) {
            if (!ABSTRACT_LOGGER.equals(loadedClass.getName()) && !CLASSIC_LOGGER.equals(loadedClass.getName())) continue;
            TransformerManager.reTransformClass(instrumentation, loadedClass);
        }
        TransformerManager.reTransformClass(instrumentation, "java.util.concurrent.ThreadPoolExecutor");
        TransformerManager.reTransformClass(instrumentation, "java.util.concurrent.ForkJoinPool");
        TransformerManager.reTransformClass(instrumentation, "java.util.concurrent.ScheduledThreadPoolExecutor");
        TransformerManager.reTransformClass(instrumentation, "java.lang.Thread");
    }

    private static void reTransformClass(Instrumentation inst, String name) {
        try {
            Class<?> retransformClass = Class.forName(name);
            inst.retransformClasses(retransformClass);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void reTransformClass(Instrumentation inst, Class name) {
        try {
            inst.retransformClasses(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static void setInstrumentation(Instrumentation instrumentation) {
        TransformerManager.instrumentation = instrumentation;
    }
}

