/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.monitor;

import com.lubanops.apm.bootstrap.collector.CollectorManager;
import com.lubanops.apm.bootstrap.collector.MonitorItem;
import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSet;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.core.monitor.MonitorReportService;
import com.lubanops.apm.core.monitor.MonitorReportServiceImpl;
import com.lubanops.apm.core.transaction.TxHarvestTask;
import com.lubanops.apm.core.utils.ReportDataBuilder;
import com.lubanops.apm.integration.access.inbound.MonitorDataBody;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class HarvestTask
implements Runnable {
    private static final Logger LOG = LogFactory.getLogger();
    private ScheduledFuture<?> scheduledFuture;
    private volatile List<MonitorItem> monitorConfigList = new ArrayList<MonitorItem>();
    private MonitorReportService monitorReportService = MonitorReportServiceImpl.getInstance();

    @Override
    public void run() {
        try {
            this.harvest(this.monitorConfigList);
            TxHarvestTask.getInstance().run();
        }
        catch (Throwable e) {
            LOG.log(Level.SEVERE, "failed to harvest:", e);
        }
    }

    public void harvest(List<MonitorItem> collectorList) {
        if (collectorList == null || collectorList.isEmpty()) {
            return;
        }
        long harvestTime = System.currentTimeMillis();
        for (MonitorItem monitorItemApp : collectorList) {
            try {
                Collector cb;
                String collectorName = monitorItemApp.getCollectorName();
                if (collectorName == null || (cb = CollectorManager.getCollector((String)collectorName)) == null) continue;
                MonitorDataBody body = new MonitorDataBody();
                List harvestList = cb.harvest();
                ArrayList<MonitorDataBody.MetricSetItem> metricSetItemList = new ArrayList<MonitorDataBody.MetricSetItem>();
                for (MetricSet metricSet : harvestList) {
                    metricSetItemList.add(ReportDataBuilder.buildMetricSetItem(metricSet));
                }
                body.setCollectorName(monitorItemApp.getCollectorName());
                body.setMonitorItemId(Integer.valueOf(monitorItemApp.getMonitorItemId().toString()).intValue());
                body.setTimestamp(harvestTime);
                body.setMetricSetList(metricSetItemList);
                if ("ProbeInfo".equals(collectorName)) {
                    this.monitorReportService.reportInnerData(body);
                    continue;
                }
                this.monitorReportService.offer(body);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "failed to harvest:", e);
            }
        }
    }

    public ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }

    public List<MonitorItem> getMonitorConfigList() {
        return this.monitorConfigList;
    }

    public void setMonitorConfigList(List<MonitorItem> monitorConfigList) {
        this.monitorConfigList = monitorConfigList;
    }
}

