/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.executor.manager;

import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.core.api.AgentService;
import com.lubanops.apm.core.common.NamedThreadFactory;
import com.lubanops.apm.core.executor.ExecuteRepository;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DefaultExecuteRepository
implements ExecuteRepository,
AgentService {
    public static final int TICKS_PER_WHEEL = 128;
    private ExecutorService sharedExecutor;
    private volatile boolean closed = false;
    private static volatile DefaultExecuteRepository instance;

    public static synchronized DefaultExecuteRepository getInstance() {
        if (instance == null) {
            instance = new DefaultExecuteRepository();
        }
        return instance;
    }

    @Override
    public ExecutorService getSharedExecutor() {
        return this.sharedExecutor;
    }

    @Override
    public void init() throws ApmRuntimeException {
        this.sharedExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("ApmSharedExecutor", true));
    }

    @Override
    public void dispose() throws ApmRuntimeException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (null != this.sharedExecutor) {
            this.sharedExecutor.shutdown();
        }
    }
}

