/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core;

import com.lubanops.apm.bootstrap.agent.AgentInfo;
import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.api.BootAPI;
import com.lubanops.apm.bootstrap.api.InstrumentationManager;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.apm.APMCollector;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.trace.TraceReportService;
import com.lubanops.apm.bootstrap.utils.AgentUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.core.BootAPIImpl;
import com.lubanops.apm.core.api.APIManager;
import com.lubanops.apm.core.executor.manager.DefaultExecuteRepository;
import com.lubanops.apm.core.master.RegionMasterService;
import com.lubanops.apm.core.monitor.MonitorReportServiceImpl;
import com.lubanops.apm.core.trace.TraceReportServiceImpl;
import com.lubanops.apm.core.transaction.TransactionReportServiceImpl;
import com.lubanops.apm.core.transfer.TransferInvokerService;
import com.lubanops.apm.core.transformer.TransformerManager;
import com.lubanops.apm.core.update.UpdateThread;
import com.lubanops.apm.core.utils.AgentPath;
import com.lubanops.apm.core.utils.ClassPoolUtils;
import java.lang.instrument.Instrumentation;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class BootStrapImpl {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static AtomicBoolean started = new AtomicBoolean(false);
    private static AtomicBoolean stopped = new AtomicBoolean(false);

    public static void main(Instrumentation instrumentation, Map argsMap) {
        try {
            AgentPath agentPath = AgentPath.build(argsMap);
            AgentUtils.setInstrumentation((Instrumentation)instrumentation);
            APIManager.init();
            AgentConfigManager.init((String)agentPath.getAgentPath());
            IdentityConfigManager.init((Map)argsMap);
            LOGGER.info("---------------------javaagent starting-----------------------------------");
            InstrumentationManager.inst = instrumentation;
            AgentInfo.setAgentStartTime((long)System.currentTimeMillis());
            String path = BootStrapImpl.class.getProtectionDomain().getCodeSource().getLocation().getFile();
            String javaagentVersion = path.substring(path.lastIndexOf("lubanops-apm-javaagent-core-") + "lubanops-apm-javaagent-core-".length(), path.lastIndexOf(".jar"));
            AgentInfo.setJavaagentVersion((String)javaagentVersion);
            LOGGER.log(Level.INFO, "javaagentVersion:" + javaagentVersion);
            APMCollector.init();
            ClassPoolUtils.init();
            TransformerManager.init(instrumentation);
            if (!StringUtils.isBlank((String)AgentConfigManager.getMasterAuthAk())) {
                new BootStrapImpl().start();
            } else {
                APIService.setBootApi((BootAPI)new BootAPIImpl());
            }
            UpdateThread.getInstance().start();
            LOGGER.info("---------------------javaagent started-----------------------------------");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "---------------------javaagent start failed-----------------------------", (Throwable)e);
        }
    }

    public void start() {
        if (started.compareAndSet(false, true)) {
            this.addShutdownHook();
            DefaultExecuteRepository.getInstance().init();
            RegionMasterService.getInstance().init();
            MonitorReportServiceImpl.getInstance().init();
            TransactionReportServiceImpl.getInstance().init();
            TraceCollector.setReportService((TraceReportService)TraceReportServiceImpl.getInstance());
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BootStrapImpl.this.stopAgent();
            }
        });
    }

    public void stopAgent() {
        if (stopped.compareAndSet(false, true)) {
            try {
                TransferInvokerService.getInstance().dispose();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "errror occured when stopping collector:", (Throwable)e);
            }
        }
    }
}

