/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jedis.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.plugin.jedis.collector.JedisClusterPoolAggregator;
import com.lubanops.apm.plugin.redis.collector.ClientInfoAggregator;
import com.lubanops.apm.plugin.redis.collector.MasterSwitchAggregator;
import com.lubanops.apm.plugin.redis.collector.RedisDetailAggregator;
import com.lubanops.apm.plugin.redis.collector.commons.RedisModeEnum;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class JedisCollector
extends Collector {
    private static final JedisCollector INSTANCE = new JedisCollector();
    private static final MasterSwitchAggregator MASTER_SWITCH_AGGREGATOR = new MasterSwitchAggregator();
    private static final ClientInfoAggregator JEDIS_INFO_AGGREGATOR = new ClientInfoAggregator();
    private static final JedisClusterPoolAggregator JEDIS_POOL_AGGREGATOR = new JedisClusterPoolAggregator();

    public static JedisCollector getInstance() {
        return INSTANCE;
    }

    public static void setJedisVersion(String s) {
        JEDIS_INFO_AGGREGATOR.setClientVersion(s);
    }

    public static String registerConnectionResource(String host, int port) {
        String connection = host;
        if (RedisDetailAggregator.isRedisDistinguishPort()) {
            StringBuilder sb = new StringBuilder(22);
            sb.append(host).append(":").append(port);
            connection = sb.toString();
            RedisDetailAggregator.REDIS_CONNECTION_ID_MAP.registerResource(connection);
        } else {
            RedisDetailAggregator.REDIS_CONNECTION_ID_MAP.registerResource(host);
        }
        return connection;
    }

    public JedisCollector mode(String mode) {
        JEDIS_INFO_AGGREGATOR.setMode(RedisModeEnum.getEnvByCode(mode));
        return this;
    }

    public void onClusterSwitch(List<String> to) {
        if (to != null && !to.isEmpty()) {
            MASTER_SWITCH_AGGREGATOR.clusterSwitch(to);
            JEDIS_INFO_AGGREGATOR.setClusterNodes(to);
        }
    }

    public void onJedisPoolCreated(String poolId, GenericObjectPool pool) {
        JEDIS_POOL_AGGREGATOR.register(poolId, pool);
    }

    public void parseParameter(Map<String, String> parameters) {
    }

    public String getCollectorName() {
        return "Jedis";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)MASTER_SWITCH_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)JEDIS_INFO_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)JEDIS_POOL_AGGREGATOR);
        INSTANCE.register();
    }
}

