/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jedis.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import java.lang.ref.WeakReference;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class GenericObjectPoolStats
implements StatsBase {
    private WeakReference<GenericObjectPool> poolRef = new WeakReference<Object>(null);
    private volatile long createdCountOld;
    private volatile long destroyedCountOld;
    private volatile long borrowedCountOld;

    void bind(GenericObjectPool genericObjectPool) {
        this.poolRef = new WeakReference<GenericObjectPool>(genericObjectPool);
    }

    public MonitorDataRow getStatus() {
        return this.harvest();
    }

    public MonitorDataRow harvest() {
        MonitorDataRow row = new MonitorDataRow();
        GenericObjectPool pool = (GenericObjectPool)this.poolRef.get();
        long createdCountNew = pool.getCreatedCount();
        long destroyedCountNew = pool.getDestroyedCount();
        long borrowedCountNew = pool.getBorrowedCount();
        if (null != pool) {
            row.put((Object)"maxTotal", (Object)pool.getMaxTotal());
            row.put((Object)"maxIdle", (Object)pool.getMaxIdle());
            row.put((Object)"minIdle", (Object)pool.getMinIdle());
            row.put((Object)"numActive", (Object)pool.getNumActive());
            row.put((Object)"numIdle", (Object)pool.getNumIdle());
            row.put((Object)"numWaiters", (Object)pool.getNumWaiters());
            row.put((Object)"createdCount", (Object)(createdCountNew - this.createdCountOld));
            row.put((Object)"destroyedCount", (Object)(destroyedCountNew - this.destroyedCountOld));
            row.put((Object)"borrowedCount", (Object)(borrowedCountNew - this.borrowedCountOld));
            row.put((Object)"maxWaitMillis", (Object)pool.getMaxWaitMillis());
            row.put((Object)"maxBorrowWaitTimeMillis", (Object)pool.getMaxBorrowWaitTimeMillis());
            row.put((Object)"meanActiveTimeMillis", (Object)pool.getMeanActiveTimeMillis());
            row.put((Object)"meanBorrowWaitTimeMillis", (Object)pool.getMeanBorrowWaitTimeMillis());
        }
        this.createdCountOld = createdCountNew;
        this.destroyedCountOld = destroyedCountNew;
        this.borrowedCountOld = borrowedCountNew;
        return row;
    }
}

