/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.sql.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdbcConnectionAggregator
extends AbstractAggregator {
    protected static final String TAG_STATS = "cnstats";
    protected static final String TAG_START = "cnstart";
    protected static final String TAG_ERROR = "error";
    protected static final String TAG_CNID = "cnid";
    private ConnectionStats[] statsMap = new ConnectionStats[100];
    private int[] ranges = new int[]{10, 100, 200, 1000, 10000};

    public String getName() {
        return "connection";
    }

    public void onConnectionCreated(int connectionId) {
        ConnectionStats st = this.getConnectionStats(connectionId);
        if (st != null) {
            st.onConnectionCreated();
        }
    }

    public void onConnectionDestoyed(int connectionId) {
        ConnectionStats st = this.getConnectionStats(connectionId);
        if (st != null) {
            st.onConnectionDestroyed();
        }
    }

    private ConnectionStats getConnectionStats(int connectionId) {
        ConnectionStats st = this.statsMap[connectionId];
        if (st != null) {
            return st;
        }
        return this.obtain(connectionId);
    }

    private synchronized ConnectionStats obtain(int connectionId) {
        ConnectionStats st = this.statsMap[connectionId];
        if (st == null) {
            st = new ConnectionStats();
            st.initRanges(this.ranges);
            this.statsMap[connectionId] = st;
        }
        return st;
    }

    public ConnectionStats onConnectionStart(Integer connectionId) {
        if (!this.isEnable) {
            return null;
        }
        ConnectionStats st = null;
        if (connectionId != null && connectionId > -1) {
            st = this.getConnectionStats(connectionId);
        }
        Map map = this.getContextMap();
        long startTime = System.nanoTime();
        if (st != null) {
            startTime = st.onStart();
            map.put(TAG_STATS, st);
            map.put(TAG_START, startTime);
            map.put(TAG_CNID, connectionId);
        } else {
            map.put(TAG_START, startTime);
        }
        return st;
    }

    public void onError(String sql) {
        if (!this.isEnable) {
            return;
        }
        Map map = this.getContextMap();
        ConnectionStats stat = (ConnectionStats)((Object)this.getContextValue(map, TAG_STATS));
        if (stat != null) {
            stat.onError(sql);
            map.put(TAG_ERROR, true);
        }
    }

    public void onFinally(String sql, int updatedCount, int readRowCount, String collectorName) {
        if (!this.isEnable) {
            return;
        }
        Map map = this.getContextMap();
        Long t = (Long)this.getContextValue(map, TAG_START);
        if (t == null) {
            return;
        }
        ConnectionStats stat = (ConnectionStats)((Object)this.getContextValue(map, TAG_STATS));
        Boolean hasError = (Boolean)this.getContextValue(map, TAG_ERROR);
        Integer connectionId = (Integer)this.getContextValue(map, TAG_CNID);
        String connectionString = "unknow";
        if (connectionId != null) {
            connectionString = Helper.CONNECTION_TARGET_MAP.getResource(connectionId.intValue());
        }
        if (hasError == null) {
            hasError = false;
        }
        long timeUsed = System.nanoTime() - t;
        if (stat != null) {
            stat.onFinally(timeUsed, sql, updatedCount, readRowCount);
        }
        TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)connectionString, (List)TransactionCollector.getTxName(), (String)collectorName);
        this.clearThreadLocal();
    }

    public List<MonitorDataRow> harvest() {
        ArrayList<MonitorDataRow> list = new ArrayList<MonitorDataRow>();
        int size = this.statsMap.length;
        for (int i = 0; i < size; ++i) {
            ConnectionStats st = this.statsMap[i];
            if (st == null) continue;
            String connectionString = Helper.CONNECTION_TARGET_MAP.getResource(i);
            MonitorDataRow map = st.harvest(this.ranges);
            if (map == null) continue;
            map.put((Object)"db", (Object)connectionString);
            list.add(map);
        }
        return list;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        if (collected == null || collected.isEmpty()) {
            return null;
        }
        long invokeCount = 0L;
        long totalTime = 0L;
        int updatedRowCount = 0;
        int readRowCount = 0;
        long errorCount = 0L;
        for (Map map : collected) {
            Integer i;
            Long v = (Long)map.get("invokeCount");
            if (v != null) {
                invokeCount += v.longValue();
            }
            if ((v = (Long)map.get("totalTime")) != null) {
                totalTime += v.longValue();
            }
            if ((i = (Integer)map.get("updatedRowCount")) != null) {
                updatedRowCount += i.intValue();
            }
            if ((i = (Integer)map.get("readRowCount")) != null) {
                readRowCount += i.intValue();
            }
            if ((v = (Long)map.get("errorCount")) == null) continue;
            errorCount += v.longValue();
        }
        MonitorDataRow row = new MonitorDataRow();
        row.put((Object)"invokeCount", (Object)invokeCount);
        row.put((Object)"totalTime", (Object)totalTime);
        row.put((Object)"updatedRowCount", (Object)updatedRowCount);
        row.put((Object)"readRowCount", (Object)readRowCount);
        row.put((Object)"errorCount", (Object)errorCount);
        ArrayList<MonitorDataRow> arrayList = new ArrayList<MonitorDataRow>();
        arrayList.add(row);
        HashMap<String, List<MonitorDataRow>> map = new HashMap<String, List<MonitorDataRow>>();
        map.put("total", arrayList);
        return map;
    }

    public void clear() {
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String db = primaryKeyMap.get("db");
        int size = this.statsMap.length;
        for (int i = 0; i < size; ++i) {
            String connectionString;
            ConnectionStats st = this.statsMap[i];
            if (st == null || (connectionString = Helper.CONNECTION_TARGET_MAP.getResource(i)) == null || !connectionString.equals(db)) continue;
            MonitorDataRow row = st.getStatus();
            row.put((Object)"db", (Object)connectionString);
            return row;
        }
        return null;
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> rowList = new ArrayList<MonitorDataRow>();
        int size = this.statsMap.length;
        for (int i = 0; i < size; ++i) {
            ConnectionStats st = this.statsMap[i];
            if (st == null) continue;
            String connectionString = Helper.CONNECTION_TARGET_MAP.getResource(i);
            MonitorDataRow row = st.getStatus();
            row.put((Object)"db", (Object)connectionString);
            rowList.add(row);
        }
        return rowList;
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public int[] getRanges() {
        return this.ranges;
    }

    public void setRanges(int[] ranges) {
        this.ranges = ranges;
    }
}

